/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.headers.Header;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.ws.policy.WSPolicyFeature;
import org.apache.cxf.wsdl.service.factory.AbstractServiceConfiguration;
import org.apache.neethi.Policy;
import org.dom4j.Document;
import org.talend.esb.job.controller.internal.SecurityArguments;
import org.talend.esb.job.controller.internal.util.DOM4JMarshaller;
import org.talend.esb.policy.correlation.feature.CorrelationIDFeature;
import org.talend.esb.sam.agent.feature.EventFeature;
import org.talend.esb.sam.common.handler.impl.CustomInfoHandler;
import org.talend.esb.sam.common.spi.EventHandler;
import org.talend.esb.servicelocator.cxf.LocatorFeature;
import routines.system.api.ESBConsumer;

public class RuntimeESBConsumer
implements ESBConsumer {
    private static final Logger LOG = Logger.getLogger(RuntimeESBConsumer.class.getName());
    private final QName operationName;
    private final EventFeature samFeature;
    private final List<Header> soapHeaders;
    private AuthorizationPolicy authorizationPolicy;
    private final ClientFactoryBean clientFactory;
    private Client client;
    private boolean enhancedResponse;

    RuntimeESBConsumer(QName serviceName, QName portName, final QName operationName, String publishedEndpointUrl, String wsdlURL, boolean useServiceLocator, Map<String, String> locatorProps, EventFeature samFeature, boolean useServiceRegistry, SecurityArguments securityArguments, Bus bus, boolean logging, List<Header> soapHeaders, boolean enhancedResponse, Object correlationIDCallbackHandler) {
        this.operationName = operationName;
        this.samFeature = samFeature;
        this.soapHeaders = soapHeaders;
        this.enhancedResponse = enhancedResponse;
        this.clientFactory = new ClientFactoryBean();
        this.clientFactory.setServiceClass(GenericServiceClass.class);
        this.clientFactory.getServiceFactory().getServiceConfigurations().add(0, new AbstractServiceConfiguration(){

            public Boolean isOperation(Method method) {
                return "invoke".equals(method.getName());
            }

            public QName getOperationName(InterfaceInfo service, Method method) {
                return operationName;
            }

            public Boolean isWrapped() {
                return Boolean.FALSE;
            }
        });
        this.clientFactory.setServiceName(serviceName);
        this.clientFactory.setEndpointName(portName);
        if (!useServiceRegistry) {
            String endpointUrl = useServiceLocator ? "locator://" + serviceName.getLocalPart() : publishedEndpointUrl;
            this.clientFactory.setAddress(endpointUrl);
        }
        if (!useServiceRegistry && null != wsdlURL) {
            this.clientFactory.setWsdlURL(wsdlURL);
        }
        this.clientFactory.setDataBinding((DataBinding)new SourceDataBinding());
        this.clientFactory.setBus(bus);
        ArrayList<Object> features = new ArrayList<Object>();
        if (useServiceLocator) {
            features.add(new LocatorFeature());
        }
        if (samFeature != null) {
            features.add(samFeature);
        }
        if (correlationIDCallbackHandler != null && !useServiceRegistry) {
            features.add(new CorrelationIDFeature());
        }
        if (null != securityArguments.getPolicy()) {
            features.add(new WSPolicyFeature(new Policy[]{securityArguments.getPolicy()}));
        }
        if (logging) {
            features.add(new LoggingFeature());
        }
        this.clientFactory.setFeatures(features);
        this.authorizationPolicy = securityArguments.buildAuthorizationPolicy();
        Map<String, Object> clientProps = securityArguments.buildClientConfig(bus, useServiceRegistry, serviceName.toString());
        clientProps.put("soap.no.validate.parts", Boolean.TRUE);
        clientProps.put("use.service.registry", Boolean.toString(useServiceRegistry));
        if ((useServiceLocator || useServiceRegistry) && null != locatorProps && !locatorProps.isEmpty()) {
            clientProps.put("esb.locator.properties", locatorProps);
        }
        if (correlationIDCallbackHandler != null) {
            clientProps.put("correlation-id.callback-handler", correlationIDCallbackHandler);
        }
        this.clientFactory.setProperties(clientProps);
        LOG.fine("Generic consumer created, serviceName: " + serviceName + " portName: " + portName + " operationName: " + operationName + " publishedEndpointUrl: " + publishedEndpointUrl + " wsdlURL: " + wsdlURL);
        LOG.fine("Generic consumer properties: " + clientProps);
    }

    public Object invoke(Object payload) throws Exception {
        LOG.fine("Generic consumer for operation " + this.operationName + " invoked with payload " + payload);
        if (payload instanceof Document) {
            return this.sendDocument((Document)payload);
        }
        if (payload instanceof Map) {
            Object samProps;
            Map map = (Map)payload;
            if (this.samFeature != null && (samProps = map.get("SAM-PROPS")) != null) {
                LOG.info("SAM custom properties received: " + samProps);
                CustomInfoHandler ciHandler = new CustomInfoHandler();
                ciHandler.setCustomInfo((Map)samProps);
                this.samFeature.setHandler((EventHandler)ciHandler);
            }
            return this.sendDocument((Document)map.get("PAYLOAD"));
        }
        throw new RuntimeException("Consumer try to send incompatible object: " + payload.getClass().getName());
    }

    private Object sendDocument(Document doc) throws Exception {
        Client client = this.getClient();
        if (null != this.soapHeaders) {
            LOG.fine("Generic consumer sendDocument soapHeaders: " + Arrays.toString(this.soapHeaders.toArray()));
            client.getRequestContext().put(Header.HEADER_LIST, this.soapHeaders);
        }
        Object[] result = null;
        try {
            result = client.invoke(this.operationName, new Object[]{DOM4JMarshaller.documentToSource(doc)});
        }
        catch (Exception ex) {
            LOG.fine("Generic consumer client.invoke throwed exception " + ex.getMessage() + " trace: " + Arrays.toString(ex.getStackTrace()));
            throw ex;
        }
        if (result != null) {
            Document response = DOM4JMarshaller.sourceToDocument((Source)result[0]);
            if (this.enhancedResponse) {
                HashMap<String, Object> enhancedBody = new HashMap<String, Object>();
                enhancedBody.put("payload", response);
                enhancedBody.put("CorrelationID", client.getResponseContext().get("CorrelationID"));
                return enhancedBody;
            }
            return response;
        }
        return null;
    }

    private Client getClient() throws BusException, EndpointException {
        if (this.client == null) {
            this.client = this.clientFactory.create();
            if (null != this.authorizationPolicy) {
                HTTPConduit conduit = (HTTPConduit)this.client.getConduit();
                conduit.setAuthorization(this.authorizationPolicy);
            }
        }
        return this.client;
    }

    static interface GenericServiceClass {
        public Object invoke(Object var1);
    }
}

