/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.ws.security.SecurityConstants;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.neethi.Policy;
import org.apache.wss4j.common.crypto.Crypto;
import org.talend.esb.job.controller.ESBEndpointConstants;
import org.talend.esb.security.saml.STSClientUtils;
import org.talend.esb.security.saml.WSPasswordCallbackHandler;

public class SecurityArguments {
    private final ESBEndpointConstants.EsbSecurity esbSecurity;
    private final Policy policy;
    private final String username;
    private final String password;
    private final String alias;
    private final Map<String, String> clientProperties;
    private final String roleName;
    private final Object securityToken;
    private final Crypto cryptoProvider;

    public SecurityArguments(ESBEndpointConstants.EsbSecurity esbSecurity, Policy policy, String username, String password, String alias, Map<String, String> clientProperties, String roleName, Object securityToken, Crypto cryptoProvider) {
        this.esbSecurity = esbSecurity;
        this.policy = policy;
        this.username = username;
        this.password = password;
        this.alias = alias;
        this.clientProperties = clientProperties;
        this.roleName = roleName;
        this.securityToken = securityToken;
        this.cryptoProvider = cryptoProvider;
    }

    public ESBEndpointConstants.EsbSecurity getEsbSecurity() {
        return this.esbSecurity;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAlias() {
        return this.alias;
    }

    public Map<String, String> getClientProperties() {
        return this.clientProperties;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public Object getSecurityToken() {
        return this.securityToken;
    }

    public Crypto getCryptoProvider() {
        return this.cryptoProvider;
    }

    public AuthorizationPolicy buildAuthorizationPolicy() {
        AuthorizationPolicy authzPolicy = null;
        if (ESBEndpointConstants.EsbSecurity.BASIC == this.esbSecurity) {
            authzPolicy = new AuthorizationPolicy();
            authzPolicy.setUserName(this.username);
            authzPolicy.setPassword(this.password);
            authzPolicy.setAuthorizationType("Basic");
        } else if (ESBEndpointConstants.EsbSecurity.DIGEST == this.esbSecurity) {
            authzPolicy = new AuthorizationPolicy();
            authzPolicy.setUserName(this.username);
            authzPolicy.setPassword(this.password);
            authzPolicy.setAuthorizationType("Digest");
        }
        return authzPolicy;
    }

    public Map<String, Object> buildClientConfig(Bus bus, boolean useServiceRegistry, String encryptionUsername) {
        HashMap<String, Object> clientConfig = new HashMap<String, Object>();
        if (ESBEndpointConstants.EsbSecurity.TOKEN == this.esbSecurity || useServiceRegistry) {
            clientConfig.put("security.username", this.username);
            clientConfig.put("security.password", this.password);
        }
        if (ESBEndpointConstants.EsbSecurity.SAML == this.esbSecurity || useServiceRegistry) {
            STSClient stsClient = this.configureSTSClient(bus);
            clientConfig.put("security.sts.client", stsClient);
            for (Map.Entry<String, String> entry : this.clientProperties.entrySet()) {
                if (!SecurityConstants.ALL_PROPERTIES.contains(entry.getKey())) continue;
                clientConfig.put(entry.getKey(), SecurityArguments.processFileURI(entry.getValue()));
            }
            if (null == this.alias) {
                String sigUser = this.clientProperties.get("security.signature.username");
                if (sigUser == null) {
                    sigUser = this.clientProperties.get("ws-security.signature.username");
                }
                clientConfig.put("security.callback-handler", new WSPasswordCallbackHandler(sigUser, this.clientProperties.get("security.signature.password")));
            } else {
                clientConfig.put("security.signature.username", this.alias);
                clientConfig.put("security.callback-handler", new WSPasswordCallbackHandler(this.alias, this.password));
            }
            if (null != this.cryptoProvider) {
                clientConfig.put("security.encryption.crypto", this.cryptoProvider);
                Object encryptUsername = clientConfig.get("security.encryption.username");
                if (encryptUsername == null) {
                    encryptUsername = this.clientProperties.get("ws-security.encryption.username");
                }
                if (encryptUsername == null || encryptUsername.toString().isEmpty()) {
                    clientConfig.put("security.encryption.username", encryptionUsername);
                }
            }
        }
        return clientConfig;
    }

    private STSClient configureSTSClient(Bus bus) {
        STSClient stsClient = null == this.alias ? STSClientUtils.createSTSClient((Bus)bus, (String)this.username, (String)this.password) : STSClientUtils.createSTSX509Client((Bus)bus, (String)this.alias);
        if (null != this.roleName && this.roleName.length() != 0) {
            STSClientUtils.applyAuthorization((STSClient)stsClient, (String)this.roleName);
        }
        if (null != this.securityToken) {
            stsClient.setOnBehalfOf(this.securityToken);
        }
        return stsClient;
    }

    private static Object processFileURI(String fileURI) {
        if (fileURI.startsWith("file:")) {
            try {
                return new URL(fileURI);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return fileURI;
    }
}

