/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceProvider;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.SAXReader;
import org.osgi.service.cm.ConfigurationException;
import org.talend.esb.job.controller.GenericOperation;
import org.talend.esb.job.controller.GenericServiceProvider;
import org.talend.esb.job.controller.JobLauncher;
import org.talend.esb.job.controller.internal.Configuration;
import org.talend.esb.job.controller.internal.util.DOM4JMarshaller;

@WebServiceProvider
@ServiceMode(value=Service.Mode.PAYLOAD)
public class GenericServiceProviderImpl
implements GenericServiceProvider,
Provider<Source> {
    private static final Logger LOG = Logger.getLogger(GenericServiceProviderImpl.class.getName());
    private final JobLauncher jobLauncher;
    private final Map<String, String> operations;
    private boolean extractHeaders;
    private Configuration configuration;
    @Resource
    private WebServiceContext context;

    public GenericServiceProviderImpl(JobLauncher jobLauncher, Map<String, String> operations) {
        this.jobLauncher = jobLauncher;
        this.operations = operations;
        this.configuration = new Configuration();
    }

    public void setExtractHeaders(boolean extractHeaders) {
        this.extractHeaders = extractHeaders;
    }

    public final Source invoke(Source request) {
        QName operationQName = (QName)this.context.getMessageContext().get((Object)"javax.xml.ws.wsdl.operation");
        LOG.info("Invoke operation '" + operationQName + "'");
        GenericOperation esbProviderCallback = this.getESBProviderCallback(operationQName.getLocalPart());
        if (esbProviderCallback == null) {
            throw new RuntimeException("Handler for operation " + operationQName + " cannot be found");
        }
        try {
            Object payload;
            Document requestDoc = null;
            if (request != null) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                StaxUtils.copy((Source)request, (OutputStream)os);
                requestDoc = new SAXReader().read((InputStream)new ByteArrayInputStream(os.toByteArray()));
            } else {
                requestDoc = DocumentHelper.createDocument();
                requestDoc.addElement("root", "");
            }
            if (this.extractHeaders) {
                HashMap<String, Object> esbRequest = new HashMap<String, Object>();
                esbRequest.put("HEADERS_SOAP", this.context.getMessageContext().get((Object)Header.HEADER_LIST));
                esbRequest.put("HEADERS_HTTP", this.context.getMessageContext().get((Object)"javax.xml.ws.http.request.headers"));
                esbRequest.put("REQUEST", requestDoc);
                esbRequest.put("CorrelationID", this.context.getMessageContext().get((Object)"CorrelationID"));
                payload = esbRequest;
            } else {
                payload = requestDoc;
            }
            LOG.fine("Generic provider invoked with payload: " + payload);
            Object result = esbProviderCallback.invoke(payload, this.isOperationRequestResponse(operationQName.getLocalPart()));
            if (result == null) {
                return null;
            }
            LOG.fine("Generic provider callback returns: " + result);
            if (result instanceof Map) {
                Map map = CastUtils.cast((Map)((Map)result));
                return this.processResult(map.get("PAYLOAD"));
            }
            return this.processResult(result);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        this.configuration.setProperties(properties);
    }

    private Source processResult(Object result) {
        Source source = null;
        if (result instanceof Document) {
            try {
                source = DOM4JMarshaller.documentToSource((Document)result);
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
        } else {
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
            if (result instanceof Throwable) {
                throw new RuntimeException((Throwable)result);
            }
            throw new RuntimeException("Provider return incompatible object: " + result.getClass().getName());
        }
        return source;
    }

    private GenericOperation getESBProviderCallback(String operationName) {
        String[] args;
        String jobName = this.operations.get(operationName);
        if (jobName == null) {
            throw new IllegalArgumentException("Job for operation '" + operationName + "' not found");
        }
        try {
            args = this.configuration.awaitArguments();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Request was interrupted when waiting for the configuration parameters.", e);
        }
        return this.jobLauncher.retrieveOperation(jobName, args);
    }

    private boolean isOperationRequestResponse(String operationName) {
        return null != this.context.getMessageContext().get((Object)"javax.xml.ws.binding.attachments.outbound");
    }
}

