/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller;

public interface ESBEndpointConstants {
    public static final String PUBLISHED_ENDPOINT_URL = "publishedEndpointUrl";
    public static final String DEFAULT_OPERATION_NAME = "defaultOperationName";
    public static final String OPERATION_NAMESPACE = "operationNamespace";
    public static final String SERVICE_NAME = "serviceName";
    public static final String PORT_NAME = "portName";
    public static final String COMMUNICATION_STYLE = "COMMUNICATION_STYLE";
    public static final String USE_SERVICE_LOCATOR = "useServiceLocator";
    public static final String USE_SERVICE_ACTIVITY_MONITOR = "useServiceActivityMonitor";
    public static final String USE_SERVICE_REGISTRY = "useServiceRegistry";
    public static final String USE_SERVICE_REGISTRY_PROP = "use.service.registry";
    public static final String USE_CRYPTO = "useCrypto";
    public static final String AUTHZ_ROLE = "role";
    public static final String ESB_SECURITY = "esbSecurity";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String ALIAS = "alias";
    public static final String SOAPACTION = "soapAction";
    public static final String WSDL_URL = "wsdlURL";
    public static final String LOG_MESSAGES = "logMessages";
    public static final String SOAP_HEADERS = "soapHeaders";
    public static final String SECURITY_TOKEN = "securityToken";
    public static final String ENHANCED_RESPONSE = "enhancedResponse";
    public static final String USE_GZIP_COMPRESSION = "useGZipCompression";
    public static final String REQUEST_PAYLOAD = "PAYLOAD";
    public static final String REQUEST_SAM_PROPS = "SAM-PROPS";
    public static final String REQUEST_SL_PROPS = "SL-PROPS";

    public static enum EsbSecurity {
        NO("NO"),
        BASIC("BASIC"),
        DIGEST("DIGEST"),
        TOKEN("TOKEN"),
        SAML("SAML");

        String esbSecurity;

        private EsbSecurity(String esbSecurity) {
            this.esbSecurity = esbSecurity;
        }

        public static EsbSecurity fromString(String value) {
            if (null == value) {
                return NO;
            }
            for (EsbSecurity esbSecurity : EsbSecurity.values()) {
                if (!esbSecurity.esbSecurity.equals(value)) continue;
                return esbSecurity;
            }
            throw new IllegalArgumentException("Unsupported secutity value: " + value);
        }
    }

    public static enum OperationStyle {
        REQUEST_RESPONSE("request-response"),
        ONE_WAY("one-way");

        String style;

        private OperationStyle(String style) {
            this.style = style;
        }

        public static boolean isRequestResponse(String value) {
            return REQUEST_RESPONSE.equals((Object)OperationStyle.fromString(value));
        }

        private static OperationStyle fromString(String value) {
            for (OperationStyle style : OperationStyle.values()) {
                if (!style.style.equals(value)) continue;
                return style;
            }
            throw new IllegalArgumentException("Unsupported communication style: " + value);
        }
    }
}

