/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.Extension;
import org.apache.cxf.bus.extension.ExtensionManager;
import org.apache.cxf.bus.extension.ExtensionManagerImpl;
import org.apache.cxf.bus.extension.ExtensionRegistry;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.headers.Header;
import org.apache.cxf.service.factory.FactoryBeanListenerManager;
import org.apache.neethi.Policy;
import org.apache.wss4j.common.crypto.Crypto;
import org.dom4j.Document;
import org.dom4j.io.DocumentSource;
import org.talend.esb.job.controller.ESBEndpointConstants;
import org.talend.esb.job.controller.internal.RuntimeESBConsumer;
import org.talend.esb.job.controller.internal.SecurityArguments;
import org.talend.esb.sam.agent.feature.EventFeature;
import org.talend.esb.security.policy.PolicyProvider;
import org.talend.esb.security.saml.STSClientCreator;
import org.talend.esb.servicelocator.cxf.LocatorFeature;
import org.w3c.dom.Node;
import routines.system.api.ESBConsumer;
import routines.system.api.ESBEndpointInfo;
import routines.system.api.ESBEndpointRegistry;

public class RuntimeESBEndpointRegistry
implements ESBEndpointRegistry {
    private static final Logger LOG = Logger.getLogger(RuntimeESBEndpointRegistry.class.getName());
    private static final String WSDL_CLIENT_EXTENSION_NAME = "org.talend.esb.registry.client.wsdl.RegistryFactoryBeanListener";
    private static final String POLICY_CLIENT_EXTENSION_NAME = "org.talend.esb.registry.client.policy.RegistryFactoryBeanListener";
    private Bus bus;
    private EventFeature samFeature;
    private LocatorFeature locatorFeature;
    private PolicyProvider policyProvider;
    private Map<String, Object> clientProperties;
    private Map<String, Object> clientPropertiesOverride;
    private Crypto cryptoProvider;
    private STSClientCreator stsClientCreator;

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public void setSamFeature(EventFeature samFeature) {
        this.samFeature = samFeature;
    }

    public void setLocatorFeature(LocatorFeature locatorFeature) {
        this.locatorFeature = locatorFeature;
    }

    public void setPolicyProvider(PolicyProvider policyProvider) {
        this.policyProvider = policyProvider;
    }

    public void setClientProperties(Map<String, Object> clientProperties) {
        this.clientProperties = clientProperties;
    }

    public void setClientPropertiesOverride(Map<String, Object> clientPropertiesOverride) {
        this.clientPropertiesOverride = clientPropertiesOverride;
    }

    public void setCryptoProvider(Crypto cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public void setStsClientCreator(STSClientCreator stsClientCreator) {
        this.stsClientCreator = stsClientCreator;
    }

    public ESBConsumer createConsumer(ESBEndpointInfo endpoint) {
        HashMap<String, Object> effectiveClientProperties;
        Map props = endpoint.getEndpointProperties();
        boolean useServiceRegistry = RuntimeESBEndpointRegistry.getBoolean(props, "useServiceRegistry");
        String authorizationRole = (String)props.get("role");
        boolean useCrypto = RuntimeESBEndpointRegistry.getBoolean(props, "useCrypto");
        ESBEndpointConstants.EsbSecurity esbSecurity = ESBEndpointConstants.EsbSecurity.fromString((String)props.get("esbSecurity"));
        Policy policy = this.buildSecurePolicy(authorizationRole, useCrypto, esbSecurity);
        HashMap<String, Object> hashMap = effectiveClientProperties = this.clientProperties == null ? null : new HashMap<String, Object>(this.clientProperties);
        if (this.clientPropertiesOverride != null) {
            if (effectiveClientProperties == null) {
                effectiveClientProperties = new HashMap<String, Object>(this.clientPropertiesOverride);
            } else {
                effectiveClientProperties.putAll(this.clientPropertiesOverride);
            }
        }
        SecurityArguments securityArguments = new SecurityArguments(esbSecurity, policy, (String)props.get("username"), (String)props.get("password"), (String)props.get("alias"), effectiveClientProperties, authorizationRole, props.get("securityToken"), (Crypto)(useCrypto || useServiceRegistry ? this.cryptoProvider : null), this.stsClientCreator);
        List<Header> soapHeaders = this.listSoapHeaders(props.get("soapHeaders"));
        if (useServiceRegistry) {
            RuntimeESBEndpointRegistry.ensureServiceRegistryAvailable(this.bus);
        }
        QName serviceName = QName.valueOf((String)props.get("serviceName"));
        String operationNamespace = (String)props.get("operationNamespace");
        QName operationName = new QName(null == operationNamespace ? serviceName.getNamespaceURI() : operationNamespace, (String)props.get("defaultOperationName"));
        return new RuntimeESBConsumer(serviceName, QName.valueOf((String)props.get("portName")), operationName, (String)props.get("publishedEndpointUrl"), (String)props.get("wsdlURL"), RuntimeESBEndpointRegistry.getBoolean(props, "useServiceLocator"), this.locatorFeature, (Map)props.get("SL-PROPS"), RuntimeESBEndpointRegistry.getBoolean(props, "useServiceActivityMonitor") ? this.samFeature : null, (Map)props.get("SAM-PROPS"), useServiceRegistry, securityArguments, this.bus, RuntimeESBEndpointRegistry.getBoolean(props, "logMessages"), soapHeaders, (Feature)props.get("httpHeadersFeature"), RuntimeESBEndpointRegistry.getBoolean(props, "enhancedResponse"), props.get("correlation-id.callback-handler"), RuntimeESBEndpointRegistry.getBoolean(props, "useGZipCompression"));
    }

    private Policy buildSecurePolicy(String authorizationRole, boolean useCrypto, ESBEndpointConstants.EsbSecurity esbSecurity) {
        Policy policy = null;
        if (ESBEndpointConstants.EsbSecurity.TOKEN == esbSecurity) {
            policy = this.policyProvider.getUsernamePolicy(this.bus);
        } else if (ESBEndpointConstants.EsbSecurity.SAML == esbSecurity) {
            policy = null != authorizationRole ? (useCrypto ? this.policyProvider.getSAMLAuthzCryptoPolicy(this.bus) : this.policyProvider.getSAMLAuthzPolicy(this.bus)) : (useCrypto ? this.policyProvider.getSAMLCryptoPolicy(this.bus) : this.policyProvider.getSAMLPolicy(this.bus));
        }
        return policy;
    }

    private List<Header> listSoapHeaders(Object soapHeadersObject) throws TransformerFactoryConfigurationError {
        if (null != soapHeadersObject) {
            if (soapHeadersObject instanceof Document) {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                try {
                    transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                }
                catch (IllegalArgumentException ex) {
                    LOG.fine("Property XMLConstants.ACCESS_EXTERNAL_DTD is not recognized");
                }
                try {
                    transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                }
                catch (IllegalArgumentException ex) {
                    LOG.fine("Property XMLConstants.ACCESS_EXTERNAL_STYLESHEET is not recognized");
                }
                try {
                    transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                catch (TransformerConfigurationException e) {
                    throw new RuntimeException("Error setting the secure processing feature", e);
                }
                ArrayList<Header> soapHeaders = new ArrayList<Header>();
                try {
                    DOMResult result = new DOMResult();
                    transformerFactory.newTransformer().transform((Source)new DocumentSource((Document)soapHeadersObject), result);
                    for (Node node = ((org.w3c.dom.Document)result.getNode()).getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
                        if (1 != node.getNodeType()) continue;
                        soapHeaders.add(new Header(new QName(node.getNamespaceURI(), node.getLocalName()), (Object)node));
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Uncaught exception during SOAP headers transformation: ", e);
                }
            } else if (soapHeadersObject instanceof List) {
                return (List)soapHeadersObject;
            }
        }
        return null;
    }

    private static boolean getBoolean(Map<String, Object> props, String propName) {
        Object propValue = props.get(propName);
        return null == propValue ? false : (Boolean)propValue;
    }

    private static void ensureServiceRegistryAvailable(Bus bus) {
        if (!bus.hasExtensionByName(WSDL_CLIENT_EXTENSION_NAME) || !bus.hasExtensionByName(POLICY_CLIENT_EXTENSION_NAME)) {
            boolean updated = false;
            Map exts = ExtensionRegistry.getRegisteredExtensions();
            updated |= RuntimeESBEndpointRegistry.setExtensionOnBusIfMissing(bus, exts, WSDL_CLIENT_EXTENSION_NAME);
            if (updated |= RuntimeESBEndpointRegistry.setExtensionOnBusIfMissing(bus, exts, POLICY_CLIENT_EXTENSION_NAME)) {
                FactoryBeanListenerManager fblm = (FactoryBeanListenerManager)bus.getExtension(FactoryBeanListenerManager.class);
                if (fblm != null) {
                    fblm.setBus(bus);
                } else {
                    throw new RuntimeException("CXF bus doesn't contain FactoryBeanListenerManager.");
                }
            }
        }
    }

    private static boolean setExtensionOnBusIfMissing(Bus bus, Map<String, Extension> exts, String extensionName) {
        if (exts.containsKey(extensionName) && !bus.hasExtensionByName(extensionName)) {
            ExtensionManager extMan = (ExtensionManager)bus.getExtension(ExtensionManager.class);
            if (extMan instanceof ExtensionManagerImpl) {
                ((ExtensionManagerImpl)extMan).add(exts.get(extensionName));
                return true;
            }
            throw new RuntimeException("A required extension '" + extensionName + "' is not loaded on the CXF bus used by Job Controller. In the same time, the bus uses unknown implementation of ExtensionManager, so it is not possible to set the extension automatically.");
        }
        return false;
    }
}

