/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal;

import java.util.Dictionary;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.talend.esb.job.controller.internal.Configuration;
import org.talend.esb.job.controller.internal.JobTask;
import routines.system.api.TalendJob;

public class SimpleJobTask
implements ManagedService,
JobTask {
    private static final Logger LOG = Logger.getLogger(SimpleJobTask.class.getName());
    private TalendJob job;
    private String name;
    private Configuration configuration;
    private FutureTask<?> future;

    public SimpleJobTask(TalendJob job, String name) {
        this.job = job;
        this.name = name;
        this.configuration = new Configuration();
        this.future = new FutureTask<Object>(new JobRunner(), null);
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        this.configuration.setProperties(properties);
    }

    @Override
    public void stop() {
        this.future.cancel(true);
    }

    @Override
    public void run() {
        this.future.run();
    }

    public class JobRunner
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info("Starting job " + SimpleJobTask.this.name);
            String[] args = null;
            try {
                args = SimpleJobTask.this.configuration.awaitArguments();
            }
            catch (InterruptedException e) {
                return;
            }
            ClassLoader oldContextCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(SimpleJobTask.this.job.getClass().getClassLoader());
                int ret = SimpleJobTask.this.job.runJobInTOS(args);
                LOG.info("Job " + SimpleJobTask.this.name + " finished, return code is " + ret);
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                LOG.log(Level.SEVERE, "RuntimeException when invoking runJobInTOS()", ex);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldContextCL);
            }
        }
    }
}

