/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.job.controller.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public final class DOM4JMarshaller {
    private static final Logger LOG = Logger.getLogger(DOM4JMarshaller.class.getName());
    private static TransformerFactory FACTORY;

    private DOM4JMarshaller() {
    }

    private static TransformerFactory getTransformerFactory() {
        if (null == FACTORY) {
            FACTORY = TransformerFactory.newInstance();
            try {
                FACTORY.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            }
            catch (IllegalArgumentException ex) {
                LOG.fine("Property XMLConstants.ACCESS_EXTERNAL_DTD is not recognized");
            }
            try {
                FACTORY.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            }
            catch (IllegalArgumentException ex) {
                LOG.fine("Property XMLConstants.ACCESS_EXTERNAL_STYLESHEET is not recognized");
            }
            try {
                FACTORY.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Error setting the secure processing feature", e);
            }
        }
        return FACTORY;
    }

    public static Document sourceToDocument(Source source) throws TransformerException, DocumentException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DOM4JMarshaller.getTransformerFactory().newTransformer().transform(source, new StreamResult(os));
        return new SAXReader().read((InputStream)new ByteArrayInputStream(os.toByteArray()));
    }

    public static Source documentToSource(Document document) throws DocumentException {
        return new StreamSource(new StringReader(document.asXML()));
    }
}

