/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.monitor;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.log4j.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.talend.esb.servicelocator.client.SLEndpoint;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.ServiceLocator;
import org.talend.esb.servicelocator.client.ServiceLocatorException;

public class LocatorMonitor {
    public static final String MONITORING = "Monitoring";
    public static final String EVENT_CATEGORY = "eventCategory";
    public static final String ADDRESS = "address";
    public static final String ACTIVE = "active";
    public static final String LAST_TIME_STARTED = "lastTimeStarted";
    public static final String LAST_TIME_STOPPED = "lastTimeStopped";
    public static final String MDC_PROPERTY_PREFIX = "sl.property.";
    public static final String COUNT = "count";
    public static final String PROTOCOL = "protocol";
    public static final String SERVICE_QNAME = "service.qname";
    public static final String TRANSPORT = "transport.type";
    private static final Logger LOG = LoggerFactory.getLogger(LocatorMonitor.class);
    private static final Marker SERVICES = MarkerFactory.getMarker((String)"SERVICES");
    private static final Marker SERVICE_INFO = MarkerFactory.getMarker((String)"SERVICE_INFO");
    private static final Marker ENDPOINTS = MarkerFactory.getMarker((String)"ENDPOINTS");
    private static final Marker ENDPOINT_INFO = MarkerFactory.getMarker((String)"ENDPOINT_INFO");
    private int scanIntervall = 60;
    private ServiceLocator sl;
    private int startDelay = 1;

    public LocatorMonitor(ServiceLocator sl, int scanIntervall) {
        this.sl = sl;
        this.scanIntervall = scanIntervall;
        this.startScanning();
    }

    private String[] addPropertiesToMDC(SLProperties properties) {
        HashSet<String> mdcKeys = new HashSet<String>();
        Collection names = properties.getPropertyNames();
        if (names.isEmpty()) {
            for (String name : names) {
                String mdcKey = MDC_PROPERTY_PREFIX + name;
                MDC.put((String)mdcKey, (Object)properties.getValues(name).toString());
                mdcKeys.add(mdcKey);
            }
        }
        return mdcKeys.toArray(new String[0]);
    }

    private void cleanMDC(String ... mdcKeys) {
        for (String key : mdcKeys) {
            MDC.remove((String)key);
        }
    }

    private String formatTimeStamp(long timestamp) {
        String timeStampStr;
        if (timestamp >= 0L) {
            Calendar timeStarted = Calendar.getInstance();
            DateFormat df = DateFormat.getDateTimeInstance();
            timeStarted.setTimeInMillis(timestamp);
            timeStampStr = df.format(timeStarted.getTime());
        } else {
            timeStampStr = "";
        }
        return timeStampStr;
    }

    private void startScanning() {
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                MDC.put((String)LocatorMonitor.EVENT_CATEGORY, (Object)LocatorMonitor.MONITORING);
                try {
                    if (LocatorMonitor.this.sl != null) {
                        List services = LocatorMonitor.this.sl.getServices();
                        int activeService = 0;
                        int totalActiveEndpoints = 0;
                        int totalOfflineEndpoints = 0;
                        for (QName service : services) {
                            List endpoints = LocatorMonitor.this.sl.getEndpoints(service);
                            int activeEndpoints = 0;
                            MDC.put((String)LocatorMonitor.SERVICE_QNAME, (Object)service);
                            for (SLEndpoint endpoint : endpoints) {
                                boolean alive = endpoint.isLive();
                                MDC.put((String)LocatorMonitor.ACTIVE, (Object)alive);
                                String address = endpoint.getAddress();
                                MDC.put((String)LocatorMonitor.ADDRESS, (Object)address);
                                String protocol = endpoint.getBinding().getValue();
                                MDC.put((String)LocatorMonitor.PROTOCOL, (Object)protocol);
                                String transport = endpoint.getTransport().getValue();
                                MDC.put((String)LocatorMonitor.TRANSPORT, (Object)transport);
                                long lastTimeStarted = endpoint.getLastTimeStarted();
                                MDC.put((String)LocatorMonitor.LAST_TIME_STARTED, (Object)LocatorMonitor.this.formatTimeStamp(lastTimeStarted));
                                long lastTimeStopped = endpoint.getLastTimeStopped();
                                MDC.put((String)LocatorMonitor.LAST_TIME_STOPPED, (Object)LocatorMonitor.this.formatTimeStamp(lastTimeStopped));
                                String[] mdcPropertyKeys = LocatorMonitor.this.addPropertiesToMDC(endpoint.getProperties());
                                if (alive) {
                                    ++activeEndpoints;
                                    ++totalActiveEndpoints;
                                    LOG.info(ENDPOINT_INFO, "Endpoint for Service {} with Address {} is alive since {}", new Object[]{service, address, LocatorMonitor.this.formatTimeStamp(lastTimeStarted)});
                                } else {
                                    LOG.warn(ENDPOINT_INFO, "Endpoint for Service {} with Address {} is down since {}", new Object[]{service, address, LocatorMonitor.this.formatTimeStamp(lastTimeStopped)});
                                    ++totalOfflineEndpoints;
                                }
                                LocatorMonitor.this.cleanMDC(mdcPropertyKeys);
                                LocatorMonitor.this.cleanMDC(new String[]{LocatorMonitor.ACTIVE, LocatorMonitor.ADDRESS, LocatorMonitor.PROTOCOL, LocatorMonitor.TRANSPORT, LocatorMonitor.LAST_TIME_STARTED, LocatorMonitor.LAST_TIME_STOPPED});
                            }
                            MDC.remove((String)LocatorMonitor.ACTIVE);
                            MDC.put((String)LocatorMonitor.COUNT, (Object)endpoints.size());
                            LOG.info(SERVICE_INFO, "{} endpoints are registered for service {}", (Object)endpoints.size(), (Object)service);
                            MDC.put((String)LocatorMonitor.ACTIVE, (Object)true);
                            MDC.put((String)LocatorMonitor.COUNT, (Object)activeEndpoints);
                            LOG.info(SERVICE_INFO, "{} endpoints are active for service {}", (Object)activeEndpoints, (Object)service);
                            MDC.put((String)LocatorMonitor.ACTIVE, (Object)false);
                            int offlineEndpoints = endpoints.size() - activeEndpoints;
                            MDC.put((String)LocatorMonitor.COUNT, (Object)offlineEndpoints);
                            if (offlineEndpoints > 0) {
                                LOG.warn(SERVICE_INFO, "{} endpoints are offline for service {}", (Object)offlineEndpoints, (Object)service);
                            } else {
                                LOG.info(SERVICE_INFO, "{} endpoints are offline for service {}", (Object)offlineEndpoints, (Object)service);
                            }
                            if (activeEndpoints > 0) {
                                ++activeService;
                            }
                            LocatorMonitor.this.cleanMDC(new String[]{LocatorMonitor.COUNT, LocatorMonitor.ACTIVE, LocatorMonitor.SERVICE_QNAME});
                        }
                        MDC.put((String)LocatorMonitor.COUNT, (Object)services.size());
                        MDC.remove((String)LocatorMonitor.ACTIVE);
                        LOG.info(SERVICES, "{} services are registered at the ServiceLocator", (Object)services.size());
                        MDC.put((String)LocatorMonitor.COUNT, (Object)activeService);
                        MDC.put((String)LocatorMonitor.ACTIVE, (Object)true);
                        LOG.info(SERVICES, "{} services are available and currently registered at the ServiceLocator", (Object)activeService);
                        MDC.put((String)LocatorMonitor.COUNT, (Object)(services.size() - activeService));
                        MDC.put((String)LocatorMonitor.ACTIVE, (Object)false);
                        LOG.info(SERVICES, "{} services are currently registered at the ServiceLocator but are not available", (Object)(services.size() - activeService));
                        MDC.put((String)LocatorMonitor.COUNT, (Object)(totalActiveEndpoints + totalOfflineEndpoints));
                        MDC.remove((String)LocatorMonitor.ACTIVE);
                        LOG.info(ENDPOINTS, "{} endpoints are registered at the ServiceLocator", (Object)(totalActiveEndpoints + totalOfflineEndpoints));
                        MDC.put((String)LocatorMonitor.COUNT, (Object)totalActiveEndpoints);
                        MDC.put((String)LocatorMonitor.ACTIVE, (Object)true);
                        LOG.info(ENDPOINTS, "{} endpoints are available and currently registered at the ServiceLocator", (Object)totalActiveEndpoints);
                        MDC.put((String)LocatorMonitor.COUNT, (Object)totalOfflineEndpoints);
                        MDC.put((String)LocatorMonitor.ACTIVE, (Object)false);
                        LOG.info(ENDPOINTS, "{} endpoints are currently registered at the ServiceLocator but are not available", (Object)totalOfflineEndpoints);
                        LocatorMonitor.this.cleanMDC(new String[]{LocatorMonitor.COUNT, LocatorMonitor.ACTIVE});
                    }
                }
                catch (ServiceLocatorException e) {
                    LOG.warn("Error during SL monitoring", (Throwable)e);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                MDC.remove((String)LocatorMonitor.EVENT_CATEGORY);
            }
        }, this.startDelay, this.scanIntervall, TimeUnit.SECONDS);
    }
}

