/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.monitor;

import java.lang.invoke.CallSite;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.talend.esb.servicelocator.client.SLEndpoint;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.ServiceLocator;
import org.talend.esb.servicelocator.client.ServiceLocatorException;

public class LocatorMonitor {
    public static final String MONITORING = "Monitoring";
    public static final String EVENT_CATEGORY = "eventCategory";
    public static final String ADDRESS = "address";
    public static final String ACTIVE = "active";
    public static final String LAST_TIME_STARTED = "lastTimeStarted";
    public static final String LAST_TIME_STOPPED = "lastTimeStopped";
    public static final String MDC_PROPERTY_PREFIX = "sl.property.";
    public static final String COUNT = "count";
    public static final String PROTOCOL = "protocol";
    public static final String SERVICE_QNAME = "service.qname";
    public static final String TRANSPORT = "transport.type";
    private static final Logger LOG = LoggerFactory.getLogger(LocatorMonitor.class);
    private static final Marker SERVICES = MarkerFactory.getMarker((String)"SERVICES");
    private static final Marker SERVICE_INFO = MarkerFactory.getMarker((String)"SERVICE_INFO");
    private static final Marker ENDPOINTS = MarkerFactory.getMarker((String)"ENDPOINTS");
    private static final Marker ENDPOINT_INFO = MarkerFactory.getMarker((String)"ENDPOINT_INFO");
    private static final String SLFJ_MARKER = "slf4j.marker";
    private static final int DEFAULT_INTERVAL = 60;
    private static final int START_DELAY = 1;
    private ScheduledExecutorService scheduler;
    private ServiceLocator serviceLocator;
    private int scanInterval = 60;

    public void start() {
        this.startScanning();
    }

    public void stop() {
        this.stopScanning();
    }

    public int getScanInterval() {
        return this.scanInterval;
    }

    public void setScanInterval(int scanInterval) {
        if (scanInterval > 0) {
            this.scanInterval = scanInterval;
        } else {
            LOG.warn("Invalid scan interval of '{}', falling back to default of {} seconds.", (Object)scanInterval, (Object)60);
            this.scanInterval = 60;
        }
    }

    public ServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public void setServiceLocator(ServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    private String[] addPropertiesToMDC(SLProperties properties) {
        HashSet<CallSite> mdcKeys = new HashSet<CallSite>();
        Collection names = properties.getPropertyNames();
        if (names.isEmpty()) {
            for (String name : names) {
                String mdcKey = MDC_PROPERTY_PREFIX + name;
                MDC.put(mdcKey, properties.getValues(name).toString());
                mdcKeys.add((CallSite)((Object)mdcKey));
            }
        }
        return mdcKeys.toArray(new String[0]);
    }

    private void cleanMDC(String ... mdcKeys) {
        for (String key : mdcKeys) {
            MDC.remove(key);
        }
    }

    private String formatTimeStamp(long timestamp) {
        String timeStampStr;
        if (timestamp >= 0L) {
            Calendar timeStarted = Calendar.getInstance();
            DateFormat df = DateFormat.getDateTimeInstance();
            timeStarted.setTimeInMillis(timestamp);
            timeStampStr = df.format(timeStarted.getTime());
        } else {
            timeStampStr = "";
        }
        return timeStampStr;
    }

    private synchronized void startScanning() {
        if (this.scheduler != null) {
            return;
        }
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ServiceLocator sl = LocatorMonitor.this.serviceLocator;
                if (sl == null) {
                    return;
                }
                MDC.put(LocatorMonitor.EVENT_CATEGORY, LocatorMonitor.MONITORING);
                try {
                    if (sl != null) {
                        List services = sl.getServices();
                        int activeService = 0;
                        int totalActiveEndpoints = 0;
                        int totalOfflineEndpoints = 0;
                        for (QName service : services) {
                            List endpoints = sl.getEndpoints(service);
                            int activeEndpoints = 0;
                            MDC.put(LocatorMonitor.SERVICE_QNAME, service);
                            for (SLEndpoint endpoint : endpoints) {
                                boolean alive = endpoint.isLive();
                                MDC.put(LocatorMonitor.ACTIVE, alive);
                                String address = endpoint.getAddress();
                                MDC.put(LocatorMonitor.ADDRESS, address);
                                String protocol = endpoint.getBinding().getValue();
                                MDC.put(LocatorMonitor.PROTOCOL, protocol);
                                String transport = endpoint.getTransport().getValue();
                                MDC.put(LocatorMonitor.TRANSPORT, transport);
                                long lastTimeStarted = endpoint.getLastTimeStarted();
                                MDC.put(LocatorMonitor.LAST_TIME_STARTED, LocatorMonitor.this.formatTimeStamp(lastTimeStarted));
                                long lastTimeStopped = endpoint.getLastTimeStopped();
                                MDC.put(LocatorMonitor.LAST_TIME_STOPPED, LocatorMonitor.this.formatTimeStamp(lastTimeStopped));
                                MDC.put(LocatorMonitor.SLFJ_MARKER, ENDPOINT_INFO);
                                String[] mdcPropertyKeys = LocatorMonitor.this.addPropertiesToMDC(endpoint.getProperties());
                                if (alive) {
                                    ++activeEndpoints;
                                    ++totalActiveEndpoints;
                                    LOG.info(ENDPOINT_INFO, "Endpoint for Service {} with Address {} is alive since {}", new Object[]{service, address, LocatorMonitor.this.formatTimeStamp(lastTimeStarted)});
                                } else {
                                    LOG.warn(ENDPOINT_INFO, "Endpoint for Service {} with Address {} is down since {}", new Object[]{service, address, LocatorMonitor.this.formatTimeStamp(lastTimeStopped)});
                                    ++totalOfflineEndpoints;
                                }
                                LocatorMonitor.this.cleanMDC(mdcPropertyKeys);
                                LocatorMonitor.this.cleanMDC(LocatorMonitor.ACTIVE, LocatorMonitor.ADDRESS, LocatorMonitor.PROTOCOL, LocatorMonitor.TRANSPORT, LocatorMonitor.LAST_TIME_STARTED, LocatorMonitor.LAST_TIME_STOPPED, LocatorMonitor.SLFJ_MARKER);
                            }
                            MDC.put(LocatorMonitor.SLFJ_MARKER, SERVICE_INFO);
                            MDC.remove(LocatorMonitor.ACTIVE);
                            MDC.put(LocatorMonitor.COUNT, endpoints.size());
                            LOG.info(SERVICE_INFO, "{} endpoints are registered for service {}", (Object)endpoints.size(), (Object)service);
                            MDC.put(LocatorMonitor.ACTIVE, true);
                            MDC.put(LocatorMonitor.COUNT, activeEndpoints);
                            LOG.info(SERVICE_INFO, "{} endpoints are active for service {}", (Object)activeEndpoints, (Object)service);
                            MDC.put(LocatorMonitor.ACTIVE, false);
                            int offlineEndpoints = endpoints.size() - activeEndpoints;
                            MDC.put(LocatorMonitor.COUNT, offlineEndpoints);
                            if (offlineEndpoints > 0) {
                                LOG.warn(SERVICE_INFO, "{} endpoints are offline for service {}", (Object)offlineEndpoints, (Object)service);
                            } else {
                                LOG.info(SERVICE_INFO, "{} endpoints are offline for service {}", (Object)offlineEndpoints, (Object)service);
                            }
                            if (activeEndpoints > 0) {
                                ++activeService;
                            }
                            LocatorMonitor.this.cleanMDC(LocatorMonitor.COUNT, LocatorMonitor.ACTIVE, LocatorMonitor.SERVICE_QNAME);
                        }
                        MDC.put(LocatorMonitor.SLFJ_MARKER, SERVICES);
                        MDC.put(LocatorMonitor.COUNT, services.size());
                        MDC.remove(LocatorMonitor.ACTIVE);
                        LOG.info(SERVICES, "{} services are registered at the ServiceLocator", (Object)services.size());
                        MDC.put(LocatorMonitor.COUNT, activeService);
                        MDC.put(LocatorMonitor.ACTIVE, true);
                        LOG.info(SERVICES, "{} services are available and currently registered at the ServiceLocator", (Object)activeService);
                        MDC.put(LocatorMonitor.COUNT, services.size() - activeService);
                        MDC.put(LocatorMonitor.ACTIVE, false);
                        LOG.info(SERVICES, "{} services are currently registered at the ServiceLocator but are not available", (Object)(services.size() - activeService));
                        MDC.put(LocatorMonitor.SLFJ_MARKER, ENDPOINTS);
                        MDC.put(LocatorMonitor.COUNT, totalActiveEndpoints + totalOfflineEndpoints);
                        MDC.remove(LocatorMonitor.ACTIVE);
                        LOG.info(ENDPOINTS, "{} endpoints are registered at the ServiceLocator", (Object)(totalActiveEndpoints + totalOfflineEndpoints));
                        MDC.put(LocatorMonitor.COUNT, totalActiveEndpoints);
                        MDC.put(LocatorMonitor.ACTIVE, true);
                        LOG.info(ENDPOINTS, "{} endpoints are available and currently registered at the ServiceLocator", (Object)totalActiveEndpoints);
                        MDC.put(LocatorMonitor.COUNT, totalOfflineEndpoints);
                        MDC.put(LocatorMonitor.ACTIVE, false);
                        LOG.info(ENDPOINTS, "{} endpoints are currently registered at the ServiceLocator but are not available", (Object)totalOfflineEndpoints);
                        LocatorMonitor.this.cleanMDC(LocatorMonitor.COUNT, LocatorMonitor.ACTIVE, LocatorMonitor.SLFJ_MARKER);
                    }
                }
                catch (ServiceLocatorException e) {
                    LOG.warn("Error during SL monitoring", (Throwable)e);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                MDC.remove(LocatorMonitor.EVENT_CATEGORY);
            }
        }, 1L, this.scanInterval, TimeUnit.SECONDS);
    }

    private synchronized void stopScanning() {
        if (this.scheduler == null) {
            return;
        }
        this.scheduler.shutdown();
        this.scheduler = null;
    }

    private static class MDC {
        private MDC() {
        }

        public static void put(String key, Object value) {
            org.slf4j.MDC.put((String)key, (String)value.toString());
        }

        public static void remove(String key) {
            org.slf4j.MDC.remove((String)key);
        }
    }
}

