/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.locator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.talend.esb.locator.NodePath;
import org.talend.esb.locator.ServiceLocatorException;

@Deprecated
public class ServiceLocator {
    private static final Logger LOG = Logger.getLogger(ServiceLocator.class.getName());
    public static final NodePath LOCATOR_ROOT_PATH = new NodePath("cxf-locator");
    public static final byte[] EMPTY_CONTENT = new byte[0];
    public static final int MAX_TIMEOUT = 60000;
    public static final PostConnectAction DO_NOTHING_ACTION = new PostConnectAction(){

        @Override
        public void process(ServiceLocator lc) {
        }
    };
    private String locatorEndpoints = "localhost:2181";
    private int sessionTimeout = 5000;
    private int connectionTimeout = 5000;
    private PostConnectAction postConnectAction = DO_NOTHING_ACTION;
    private volatile ZooKeeper zk;

    public synchronized void connect() throws InterruptedException, ServiceLocatorException {
        this.disconnect();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Start connect session");
        }
        CountDownLatch connectionLatch = new CountDownLatch(1);
        this.zk = this.createZooKeeper(connectionLatch);
        boolean connected = connectionLatch.await(this.connectionTimeout, TimeUnit.MILLISECONDS);
        if (!connected) {
            throw new ServiceLocatorException("Connection to Service Locator failed.");
        }
        this.postConnectAction.process(this);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "End connect session");
        }
    }

    public synchronized void disconnect() throws InterruptedException, ServiceLocatorException {
        if (this.zk != null) {
            this.zk.close();
            this.zk = null;
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Disconnected service locator session.");
            }
        }
    }

    public synchronized void register(QName serviceName, String endpoint) throws ServiceLocatorException, InterruptedException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Registering endpoint " + endpoint + " for service " + serviceName + "...");
        }
        this.checkConnection();
        NodePath serviceNodePath = LOCATOR_ROOT_PATH.child(serviceName.toString());
        this.ensurePathExists(serviceNodePath, CreateMode.PERSISTENT);
        NodePath endpointNodePath = serviceNodePath.child(endpoint);
        this.ensurePathExists(endpointNodePath, CreateMode.EPHEMERAL);
    }

    public synchronized void unregister(QName serviceName, String endpoint) throws ServiceLocatorException, InterruptedException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Unregistering endpoint " + endpoint + " for service " + serviceName + "...");
        }
        NodePath serviceNodePath = LOCATOR_ROOT_PATH.child(serviceName.toString());
        NodePath endpointNodePath = serviceNodePath.child(endpoint);
        this.checkConnection();
        this.ensurePathDeleted(endpointNodePath, false);
        this.ensurePathDeleted(serviceNodePath, true);
    }

    public List<QName> getServices() throws InterruptedException, ServiceLocatorException {
        List<String> servicePaths;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Getting all services...");
        }
        this.checkConnection();
        try {
            servicePaths = this.getChildren(LOCATOR_ROOT_PATH);
        }
        catch (KeeperException e) {
            throw this.locatorException((Exception)((Object)e));
        }
        ArrayList<QName> services = new ArrayList<QName>();
        for (String servicePath : servicePaths) {
            QName service = QName.valueOf(NodePath.decode(servicePath));
            services.add(service);
        }
        return services;
    }

    public synchronized List<String> lookup(QName serviceName) throws ServiceLocatorException, InterruptedException {
        List<String> children;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Looking up endpoints of service " + serviceName + "...");
        }
        this.checkConnection();
        try {
            NodePath providerPath = LOCATOR_ROOT_PATH.child(serviceName.toString());
            if (this.nodeExists(providerPath)) {
                children = this.decode(this.getChildren(providerPath));
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Lookup of service " + serviceName + " failed, service is not known.");
                }
                children = Collections.emptyList();
            }
        }
        catch (KeeperException e) {
            throw this.locatorException((Exception)((Object)e));
        }
        return children;
    }

    public void setLocatorEndpoints(String endpoints) {
        this.locatorEndpoints = endpoints;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Locator endpoints set to " + this.locatorEndpoints);
        }
    }

    public void setSessionTimeout(int timeout) {
        if (60000 < timeout) {
            this.sessionTimeout = 60000;
            LOG.warning("Locator session timeout truncated to 60000");
        } else {
            this.sessionTimeout = timeout;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Locator session timeout set to: " + this.sessionTimeout);
            }
        }
    }

    public void setConnectionTimeout(int timeout) {
        if (60000 < timeout) {
            this.connectionTimeout = 60000;
            LOG.warning("Locator connection timeout truncated to 60000");
        } else {
            this.connectionTimeout = timeout;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Locator connection timeout set to: " + this.connectionTimeout);
            }
        }
    }

    public void setPostConnectAction(PostConnectAction postConnectAction) {
        this.postConnectAction = postConnectAction;
    }

    private boolean isConnected() {
        return this.zk != null && this.zk.getState().equals((Object)ZooKeeper.States.CONNECTED);
    }

    private void checkConnection() throws ServiceLocatorException {
        if (!this.isConnected()) {
            throw new ServiceLocatorException("The connection to Service Locator was not established.");
        }
    }

    private void ensurePathExists(NodePath path, CreateMode mode) throws ServiceLocatorException, InterruptedException {
        block7: {
            try {
                if (!this.nodeExists(path)) {
                    this.createNode(path, mode);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Node " + path + " created.");
                    }
                } else if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Node " + path + " already exists.");
                }
            }
            catch (KeeperException e) {
                if (!e.code().equals((Object)KeeperException.Code.NODEEXISTS)) {
                    throw this.locatorException((Exception)((Object)e));
                }
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.fine("Some other client created node" + path + " concurrently.");
            }
        }
    }

    private void ensurePathDeleted(NodePath path, boolean canHaveChildren) throws ServiceLocatorException, InterruptedException {
        try {
            if (this.nodeExists(path) && this.deleteNode(path, canHaveChildren)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Node " + path + " deteted.");
                }
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Node " + path + " has already been deleted.");
            }
        }
        catch (KeeperException e) {
            if (e.code().equals((Object)KeeperException.Code.NONODE)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Some other client deleted node" + path + " concurrently.");
                }
            }
            throw this.locatorException((Exception)((Object)e));
        }
    }

    private boolean nodeExists(NodePath path) throws KeeperException, InterruptedException {
        return this.zk.exists(path.toString(), false) != null;
    }

    private void createNode(NodePath path, CreateMode mode) throws KeeperException, InterruptedException {
        this.zk.create(path.toString(), EMPTY_CONTENT, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
    }

    private boolean deleteNode(NodePath path, boolean canHaveChildren) throws KeeperException, InterruptedException {
        try {
            if (this.getChildren(path).isEmpty()) {
                this.zk.delete(path.toString(), -1);
            }
            return true;
        }
        catch (KeeperException e) {
            if (e.code().equals((Object)KeeperException.Code.NOTEMPTY) && canHaveChildren) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Some other client created children nodes in the node" + path + " concurrently. Therefore, we can not delete it.");
                }
                return false;
            }
            throw e;
        }
    }

    private List<String> getChildren(NodePath path) throws KeeperException, InterruptedException {
        return this.zk.getChildren(path.toString(), false);
    }

    private List<String> decode(List<String> encoded) {
        ArrayList<String> raw = new ArrayList<String>();
        for (String oneEncoded : encoded) {
            raw.add(NodePath.decode(oneEncoded));
        }
        return raw;
    }

    private ServiceLocatorException locatorException(Exception e) {
        if (LOG.isLoggable(Level.SEVERE)) {
            LOG.log(Level.SEVERE, "The service locator server signaled an error", e);
        }
        return new ServiceLocatorException("The service locator server signaled an error.", e);
    }

    protected ZooKeeper createZooKeeper(CountDownLatch connectionLatch) throws ServiceLocatorException {
        try {
            return new ZooKeeper(this.locatorEndpoints, this.sessionTimeout, (Watcher)new WatcherImpl(connectionLatch));
        }
        catch (IOException e) {
            throw new ServiceLocatorException("At least one of the endpoints " + this.locatorEndpoints + " does not represent a valid address.");
        }
    }

    public class WatcherImpl
    implements Watcher {
        private CountDownLatch connectionLatch;

        public WatcherImpl(CountDownLatch connectionLatch) {
            this.connectionLatch = connectionLatch;
        }

        public void process(WatchedEvent event) {
            block8: {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Event with state " + event.getState() + " sent.");
                }
                Watcher.Event.KeeperState eventState = event.getState();
                try {
                    if (eventState == Watcher.Event.KeeperState.SyncConnected) {
                        ServiceLocator.this.ensurePathExists(LOCATOR_ROOT_PATH, CreateMode.PERSISTENT);
                        this.connectionLatch.countDown();
                    } else if (eventState == Watcher.Event.KeeperState.Expired) {
                        ServiceLocator.this.connect();
                    }
                }
                catch (InterruptedException e) {
                    if (LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "An InterruptedException was thrown while waiting for an answer from the Service Locator", e);
                    }
                }
                catch (ServiceLocatorException e) {
                    if (!LOG.isLoggable(Level.SEVERE)) break block8;
                    LOG.log(Level.SEVERE, "Failed to execute an request to Service Locator.", e);
                }
            }
        }
    }

    static interface PostConnectAction {
        public void process(ServiceLocator var1);
    }
}

