/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.client.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.MetadataType;
import org.apache.cxf.wsdl.WSAEndpointReferenceUtils;
import org.talend.esb.servicelocator.client.BindingType;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.SLPropertiesImpl;
import org.talend.esb.servicelocator.client.ServiceLocatorException;
import org.talend.esb.servicelocator.client.TransportType;
import org.talend.esb.servicelocator.client.internal.endpoint.EndpointDataType;
import org.talend.esb.servicelocator.client.internal.endpoint.ObjectFactory;
import org.talend.esb.servicelocator.client.internal.endpoint.ServiceLocatorPropertiesType;
import org.talend.esb.servicelocator.cxf.internal.SLPropertiesConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContentHolder {
    private static final Logger LOG = Logger.getLogger(ContentHolder.class.getName());
    private static final ObjectFactory ENDPOINT_OBJECT_FACTORY = new ObjectFactory();
    private static final String SERVICE_LOCATOR_PROPERTIES_NS = "http://talend.org/esb/serviceLocator/4.2";
    private static final String SERVICE_LOCATOR_PROPERTIES_LN = "ServiceLocatorProperties";
    private static final org.apache.cxf.ws.addressing.ObjectFactory WSA_OBJECT_FACTORY = new org.apache.cxf.ws.addressing.ObjectFactory();
    protected EndpointDataType epd;
    protected EndpointReferenceType epr;
    private SLProperties props;

    public ContentHolder(EndpointDataType endpointData) {
        this.epd = endpointData;
    }

    public ContentHolder(byte[] content) {
        if (content == null) {
            throw new IllegalArgumentException("content must not be null.");
        }
        this.epd = ContentHolder.toEndPointData(content);
        Element eprRoot = (Element)this.epd.getAny();
        this.epr = this.toEndPointReference(eprRoot);
        this.props = this.extractProperties(this.epr);
    }

    public byte[] getContent() throws ServiceLocatorException {
        return ContentHolder.serialize(this.epd);
    }

    public long getLastTimeStarted() {
        return this.epd.getLastTimeStarted();
    }

    public void setLastTimeStarted(long lastTimeStarted) {
        this.epd.setLastTimeStarted(lastTimeStarted);
    }

    public long getLastTimeStopped() {
        return this.epd.getLastTimeStopped();
    }

    public void setLastTimeStopped(long lastTimeStopped) {
        this.epd.setLastTimeStopped(lastTimeStopped);
    }

    public BindingType getBinding() {
        return BindingType.fromValue(this.epd.getBinding().value());
    }

    public TransportType getTransport() {
        return TransportType.fromValue(this.epd.getTransport().value());
    }

    public String getAddress() {
        return WSAEndpointReferenceUtils.getAddress((EndpointReferenceType)this.epr);
    }

    public void setAddress(String address) {
        WSAEndpointReferenceUtils.setAddress((EndpointReferenceType)this.epr, (String)address);
    }

    public SLProperties getProperties() {
        return this.props;
    }

    private static byte[] serialize(EndpointDataType endpointData) throws ServiceLocatorException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(50000);
        try {
            JAXBElement<EndpointDataType> epd = ENDPOINT_OBJECT_FACTORY.createEndpointData(endpointData);
            JAXBContext jc = JAXBContext.newInstance((String)"org.talend.esb.servicelocator.client.internal.endpoint");
            Marshaller m = jc.createMarshaller();
            m.marshal(epd, (OutputStream)outputStream);
        }
        catch (JAXBException e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Failed to serialize endpoint data", e);
            }
            throw new ServiceLocatorException("Failed to serialize endpoint data", e);
        }
        return outputStream.toByteArray();
    }

    private static EndpointDataType toEndPointData(byte[] content) {
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"org.talend.esb.servicelocator.client.internal.endpoint");
            Unmarshaller um = jc.createUnmarshaller();
            JAXBElement slEndpoint = (JAXBElement)um.unmarshal((InputStream)is);
            return (EndpointDataType)slEndpoint.getValue();
        }
        catch (JAXBException e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Failed to deserialize endpoint data", e);
            }
            EndpointDataType endpointData = ENDPOINT_OBJECT_FACTORY.createEndpointDataType();
            endpointData.setLastTimeStarted(-1L);
            endpointData.setLastTimeStopped(-1L);
            return endpointData;
        }
    }

    private EndpointReferenceType toEndPointReference(Element root) {
        EndpointReferenceType epr = null;
        if (root != null) {
            try {
                JAXBContext jc = JAXBContext.newInstance((String)"org.apache.cxf.ws.addressing");
                Unmarshaller um = jc.createUnmarshaller();
                JAXBElement eprElem = (JAXBElement)um.unmarshal((Node)root);
                epr = (EndpointReferenceType)eprElem.getValue();
            }
            catch (JAXBException e) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Failed to deserialize endpoint reference", e);
                }
            }
        } else {
            LOG.log(Level.SEVERE, "No endpoint reference found in content");
        }
        return epr != null ? epr : WSA_OBJECT_FACTORY.createEndpointReferenceType();
    }

    private SLProperties extractProperties(EndpointReferenceType epr) {
        MetadataType metadata = epr.getMetadata();
        if (metadata != null) {
            List metaAny = metadata.getAny();
            for (Object any : metaAny) {
                Element root;
                if (!(any instanceof Element) || !this.isServiceLocatorProperties(root = (Element)any)) continue;
                ServiceLocatorPropertiesType slp = this.toServiceLocatorProperties(root);
                return SLPropertiesConverter.toSLProperties(slp);
            }
        }
        return new SLPropertiesImpl();
    }

    private ServiceLocatorPropertiesType toServiceLocatorProperties(Element root) {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"org.talend.esb.servicelocator.client.internal.endpoint");
            Unmarshaller um = jc.createUnmarshaller();
            JAXBElement slp = (JAXBElement)um.unmarshal((Node)root);
            return (ServiceLocatorPropertiesType)slp.getValue();
        }
        catch (JAXBException e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Failed to deserialize service locator properties", e);
            }
            return ENDPOINT_OBJECT_FACTORY.createServiceLocatorPropertiesType();
        }
    }

    private boolean isServiceLocatorProperties(Element elem) {
        return SERVICE_LOCATOR_PROPERTIES_LN.equals(elem.getLocalName()) && SERVICE_LOCATOR_PROPERTIES_NS.equals(elem.getNamespaceURI());
    }
}

