/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.MetadataType;
import org.apache.cxf.ws.addressing.ObjectFactory;
import org.apache.cxf.wsdl.WSAEndpointReferenceUtils;
import org.talend.esb.servicelocator.client.BindingType;
import org.talend.esb.servicelocator.client.EndpointProvider;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.ServiceLocatorException;
import org.talend.esb.servicelocator.client.TransportType;
import org.talend.esb.servicelocator.client.internal.endpoint.ServiceLocatorPropertiesType;
import org.talend.esb.servicelocator.cxf.internal.SLPropertiesConverter;
import org.w3c.dom.Node;

public class CXFEndpointProvider
implements EndpointProvider {
    private static final Logger LOG = Logger.getLogger(CXFEndpointProvider.class.getName());
    private static final ObjectFactory WSA_OBJECT_FACTORY = new ObjectFactory();
    private static final org.talend.esb.servicelocator.client.internal.endpoint.ObjectFactory SL_OBJECT_FACTORY = new org.talend.esb.servicelocator.client.internal.endpoint.ObjectFactory();
    public static final String SOAP11_BINDING_ID = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String SOAP12_BINDING_ID = "http://schemas.xmlsoap.org/wsdl/soap12/";
    public static final String JAXRS_BINDING_ID = "http://apache.org/cxf/binding/jaxrs";
    public static final String CXF_HTTP_TRANSPORT_ID = "http://cxf.apache.org/transports/http";
    public static final String SOAP_HTTP_TRANSPORT_ID = "http://schemas.xmlsoap.org/soap/http";
    private QName sName;
    private EndpointReferenceType epr;
    private BindingType bindingType;
    private TransportType transportType;
    private long lastTimeStarted = -1L;
    private long lastTimeStopped = -1L;

    public CXFEndpointProvider(QName serviceName, EndpointReferenceType endpointReference) {
        this(serviceName, null, null, endpointReference);
    }

    public CXFEndpointProvider(QName serviceName, String bindingId, String transportId, EndpointReferenceType endpointReference) {
        this.sName = serviceName;
        this.epr = endpointReference;
        this.bindingType = CXFEndpointProvider.map2BindingType(bindingId);
        this.transportType = CXFEndpointProvider.map2TransportType(transportId);
    }

    public CXFEndpointProvider(QName serviceName, String address, SLProperties properties) {
        this(serviceName, CXFEndpointProvider.createEPR(address, properties));
    }

    public CXFEndpointProvider(Server server, String address, SLProperties properties) {
        this(CXFEndpointProvider.getServiceName(server), CXFEndpointProvider.getBindingId(server), CXFEndpointProvider.getTransportId(server), CXFEndpointProvider.createEPR(server, address, properties));
    }

    @Override
    public QName getServiceName() {
        return this.sName;
    }

    @Override
    public String getAddress() {
        return this.epr.getAddress().getValue();
    }

    @Override
    public BindingType getBinding() {
        return this.bindingType;
    }

    @Override
    public TransportType getTransport() {
        return this.transportType;
    }

    public void setLastTimeStartedToCurrent() {
        this.lastTimeStarted = System.currentTimeMillis();
    }

    @Override
    public long getLastTimeStarted() {
        return this.lastTimeStarted;
    }

    public void setLastTimeStoppedToCurrent() {
        this.lastTimeStopped = System.currentTimeMillis();
    }

    public void setLastTimeStopped(long lastTimeStopped) {
        this.lastTimeStopped = lastTimeStopped;
    }

    @Override
    public long getLastTimeStopped() {
        return this.lastTimeStopped;
    }

    @Override
    public void addEndpointReference(Node parent) throws ServiceLocatorException {
        this.serializeEPR(this.epr, parent);
    }

    private void serializeEPR(EndpointReferenceType wsAddr, Node parent) throws ServiceLocatorException {
        try {
            JAXBElement ep = WSA_OBJECT_FACTORY.createEndpointReference(wsAddr);
            JAXBContext jc = JAXBContext.newInstance((String)"org.apache.cxf.ws.addressing:org.talend.esb.servicelocator.client.internal.endpoint");
            Marshaller m = jc.createMarshaller();
            m.marshal((Object)ep, parent);
        }
        catch (JAXBException e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Failed to serialize endpoint data", e);
            }
            throw new ServiceLocatorException("Failed to serialize endpoint data", e);
        }
    }

    private static EndpointReferenceType createEPR(String address, SLProperties props) {
        EndpointReferenceType epr = WSAEndpointReferenceUtils.getEndpointReference((String)address);
        if (props != null) {
            CXFEndpointProvider.addProperties(epr, props);
        }
        return epr;
    }

    private static EndpointReferenceType createEPR(Server server, String address, SLProperties props) {
        EndpointReferenceType sourceEPR = server.getEndpoint().getEndpointInfo().getTarget();
        EndpointReferenceType targetEPR = WSAEndpointReferenceUtils.duplicate((EndpointReferenceType)sourceEPR);
        WSAEndpointReferenceUtils.setAddress((EndpointReferenceType)targetEPR, (String)address);
        if (props != null) {
            CXFEndpointProvider.addProperties(targetEPR, props);
        }
        return targetEPR;
    }

    private static void addProperties(EndpointReferenceType epr, SLProperties props) {
        MetadataType metadata = WSAEndpointReferenceUtils.getSetMetadata((EndpointReferenceType)epr);
        ServiceLocatorPropertiesType jaxbProps = SLPropertiesConverter.toServiceLocatorPropertiesType(props);
        JAXBElement<ServiceLocatorPropertiesType> slp = SL_OBJECT_FACTORY.createServiceLocatorProperties(jaxbProps);
        metadata.getAny().add(slp);
    }

    private static QName getServiceName(Server server) {
        QName serviceName;
        String bindingId = CXFEndpointProvider.getBindingId(server);
        EndpointInfo eInfo = server.getEndpoint().getEndpointInfo();
        if (JAXRS_BINDING_ID.equals(bindingId)) {
            serviceName = eInfo.getName();
        } else {
            ServiceInfo serviceInfo = eInfo.getService();
            serviceName = serviceInfo.getName();
        }
        return serviceName;
    }

    private static String getBindingId(Server server) {
        Endpoint ep = server.getEndpoint();
        BindingInfo bi = ep.getBinding().getBindingInfo();
        return bi.getBindingId();
    }

    private static String getTransportId(Server server) {
        EndpointInfo ei = server.getEndpoint().getEndpointInfo();
        return ei.getTransportId();
    }

    private static BindingType map2BindingType(String bindingId) {
        BindingType type = BindingType.OTHER;
        if (SOAP11_BINDING_ID.equals(bindingId)) {
            type = BindingType.SOAP11;
        } else if (SOAP12_BINDING_ID.equals(bindingId)) {
            type = BindingType.SOAP12;
        } else if (JAXRS_BINDING_ID.equals(bindingId)) {
            type = BindingType.JAXRS;
        }
        return type;
    }

    private static TransportType map2TransportType(String transportId) {
        TransportType type = TransportType.OTHER;
        if (CXF_HTTP_TRANSPORT_ID.equals(transportId) || SOAP_HTTP_TRANSPORT_ID.equals(transportId)) {
            type = TransportType.HTTP;
        }
        return type;
    }
}

