/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf.internal;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.service.model.EndpointInfo;
import org.talend.esb.servicelocator.client.SLEndpoint;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.ServiceLocator;
import org.talend.esb.servicelocator.client.ServiceLocatorException;
import org.talend.esb.servicelocator.cxf.internal.CXFEndpointProvider;

public class LocatorRegistrar
implements ServerLifeCycleListener,
ServiceLocator.PostConnectAction {
    private static final Logger LOG = Logger.getLogger(LocatorRegistrar.class.getPackage().getName());
    private Bus bus;
    private ServiceLocator locatorClient;
    private String endpointPrefix = "";
    private Map<Server, CXFEndpointProvider> registeredServers = Collections.synchronizedMap(new LinkedHashMap());
    private boolean listenForServersEnabled;

    public void startServer(Server server) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Server " + server + " starting...");
        }
        if (this.listenForServersEnabled) {
            this.registerServer(server);
        }
    }

    public void stopServer(Server server) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Server " + server + " stopping...");
        }
        if (this.registeredServers.containsKey(server)) {
            this.unregisterServer(server);
        }
    }

    public void startListenForServers() {
        this.check(this.bus, "bus", "startListenForServers");
        this.listenForServersEnabled = true;
        this.registerAvailableServers();
    }

    public void stopListenForServers() {
        this.listenForServersEnabled = false;
    }

    @Override
    public void process(ServiceLocator lc) {
        for (Server server : this.registeredServers.keySet()) {
            this.registerServer(this.registeredServers.get(server));
        }
    }

    public void setBus(Bus bus) {
        if (bus != this.bus) {
            this.bus = bus;
            this.registerListener();
        }
    }

    public void setEndpointPrefix(String endpointPrefix) {
        this.endpointPrefix = endpointPrefix != null ? endpointPrefix : "";
    }

    public void setServiceLocator(ServiceLocator locatorClient) {
        this.locatorClient = locatorClient;
        locatorClient.setPostConnectAction(this);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Locator client was set.");
        }
    }

    private void registerListener() {
        ServerLifeCycleManager manager = (ServerLifeCycleManager)this.bus.getExtension(ServerLifeCycleManager.class);
        if (manager != null) {
            manager.registerListener((ServerLifeCycleListener)this);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Server life cycle listener registered.");
            }
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "ServerLifeCycleManager is not available.");
        }
    }

    public void registerServer(Server server) {
        this.registerServer(server, null);
    }

    public void registerServer(Server server, SLProperties props) {
        CXFEndpointProvider endpoint;
        block6: {
            this.check(this.locatorClient, "serviceLocator", "registerEndpoint");
            String absAddress = this.getAddress(server);
            if (!absAddress.startsWith("http://")) {
                absAddress = this.endpointPrefix + absAddress;
            }
            endpoint = new CXFEndpointProvider(server, absAddress, props);
            endpoint.setLastTimeStartedToCurrent();
            QName serviceName = endpoint.getServiceName();
            try {
                SLEndpoint slEndpoint = this.locatorClient.getEndpoint(serviceName, absAddress);
                if (slEndpoint != null) {
                    long lastTimeStopped = slEndpoint.getLastTimeStopped();
                    endpoint.setLastTimeStopped(lastTimeStopped);
                }
                this.registerServer(endpoint);
            }
            catch (ServiceLocatorException e) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "ServiceLocator Exception thrown when registering endpoint.", e);
                }
            }
            catch (InterruptedException e) {
                if (!LOG.isLoggable(Level.SEVERE)) break block6;
                LOG.log(Level.SEVERE, "Interrupted Exception thrown when registering endpoint.", e);
            }
        }
        this.registeredServers.put(server, endpoint);
    }

    private void registerServer(CXFEndpointProvider endpointProvider) {
        block4: {
            try {
                this.locatorClient.register(endpointProvider);
            }
            catch (ServiceLocatorException e) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "ServiceLocator Exception thrown when registering for endpoint " + endpointProvider, e);
                }
            }
            catch (InterruptedException e) {
                if (!LOG.isLoggable(Level.SEVERE)) break block4;
                LOG.log(Level.SEVERE, "Interrupted Exception thrown when registering  for endpoint " + endpointProvider, e);
            }
        }
    }

    private void unregisterServer(Server server) {
        block4: {
            try {
                CXFEndpointProvider epp = this.registeredServers.get(server);
                epp.setLastTimeStoppedToCurrent();
                this.locatorClient.unregister(epp);
            }
            catch (ServiceLocatorException e) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "ServiceLocator Exception thrown during unregister endpoint. ", e);
                }
            }
            catch (InterruptedException e) {
                if (!LOG.isLoggable(Level.SEVERE)) break block4;
                LOG.log(Level.SEVERE, "Interrupted Exception thrown during unregister endpoint.", e);
            }
        }
    }

    private void registerAvailableServers() {
        ServerRegistry serverRegistry = (ServerRegistry)this.bus.getExtension(ServerRegistry.class);
        List servers = serverRegistry.getServers();
        for (Server server : servers) {
            this.registerServer(server);
        }
    }

    private String getAddress(Server server) {
        EndpointInfo eInfo = server.getEndpoint().getEndpointInfo();
        return eInfo.getAddress();
    }

    private void check(Object obj, String propertyName, String methodName) {
        if (obj == null) {
            throw new IllegalStateException("The property " + propertyName + " must be set before " + methodName + " can be called.");
        }
    }
}

