/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf.internal;

import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientLifeCycleListener;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.extension.BusExtension;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.SLPropertiesMatcher;
import org.talend.esb.servicelocator.cxf.internal.LocatorClientEnabler;
import org.talend.esb.servicelocator.cxf.internal.LocatorRegistrar;

public class ServiceLocatorManager
implements BusExtension {
    private LocatorRegistrar locatorRegistrar;
    private LocatorClientEnabler clientEnabler;
    private Bus bus;

    public void listenForAllServers() {
        this.locatorRegistrar.startListenForServers();
    }

    public void registerServer(Server server) {
        this.locatorRegistrar.registerServer(server);
    }

    public void registerServer(Server server, SLProperties props) {
        this.locatorRegistrar.registerServer(server, props);
    }

    public void listenForAllClients() {
        this.listenForAllClients(null);
    }

    public void listenForAllClients(String selectionStrategy) {
        ClientLifeCycleManager clcm = (ClientLifeCycleManager)this.bus.getExtension(ClientLifeCycleManager.class);
        clcm.registerListener((ClientLifeCycleListener)new ClientLifeCycleListenerForLocator());
    }

    public void enableClient(Client client) {
        this.enableClient(client, null);
    }

    public void enableClient(Client client, SLPropertiesMatcher matcher) {
        this.enableClient(client, matcher, null);
    }

    public void enableClient(final Client client, SLPropertiesMatcher matcher, String selectionStrategy) {
        this.clientEnabler.enable(new LocatorClientEnabler.ConduitSelectorHolder(){

            @Override
            public void setConduitSelector(ConduitSelector selector) {
                client.setConduitSelector(selector);
            }

            @Override
            public ConduitSelector getConduitSelector() {
                return client.getConduitSelector();
            }
        }, matcher, selectionStrategy);
    }

    public void enableClient(ClientConfiguration clientConf) {
        this.enableClient(clientConf, null);
    }

    public void enableClient(ClientConfiguration clientConf, SLPropertiesMatcher matcher) {
        this.enableClient(clientConf, matcher, null);
    }

    public void enableClient(final ClientConfiguration clientConfiguration, SLPropertiesMatcher matcher, String selectionStrategy) {
        this.clientEnabler.enable(new LocatorClientEnabler.ConduitSelectorHolder(){

            @Override
            public void setConduitSelector(ConduitSelector selector) {
                clientConfiguration.setConduitSelector(selector);
            }

            @Override
            public ConduitSelector getConduitSelector() {
                return clientConfiguration.getConduitSelector();
            }
        }, matcher, selectionStrategy);
    }

    public void setBus(Bus bus) {
        if (bus != this.bus) {
            this.bus = bus;
            if (bus != null) {
                bus.setExtension((Object)this, ServiceLocatorManager.class);
            }
        }
    }

    public void setLocatorRegistrar(LocatorRegistrar locatorRegistrar) {
        this.locatorRegistrar = locatorRegistrar;
    }

    public void setLocatorClientEnabler(LocatorClientEnabler clientEnabler) {
        this.clientEnabler = clientEnabler;
    }

    public Class<?> getRegistrationType() {
        return ServiceLocatorManager.class;
    }

    class ClientLifeCycleListenerForLocator
    implements ClientLifeCycleListener {
        ClientLifeCycleListenerForLocator() {
        }

        public void clientCreated(Client client) {
            ServiceLocatorManager.this.enableClient(client);
        }

        public void clientDestroyed(Client client) {
        }
    }
}

