/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.locator;

import java.util.logging.Level;
import java.util.logging.Logger;

public class NodePath {
    private static final Logger LOG = Logger.getLogger(NodePath.class.getPackage().getName());
    public static final char SEPARATOR = '/';
    private String path;

    public NodePath(String ... pathSegments) {
        if (pathSegments == null || pathSegments.length == 0) {
            LOG.log(Level.SEVERE, "At least one path segment must be defined.");
            throw new IllegalArgumentException("At least one path segment must be defined.");
        }
        StringBuffer rawPath = new StringBuffer();
        for (String pathSegment : pathSegments) {
            this.checkValidPathSegment(pathSegment);
            String encodedPathSegment = NodePath.encode(pathSegment);
            rawPath.append('/').append(encodedPathSegment);
        }
        this.path = rawPath.toString();
    }

    private NodePath(NodePath parentPath, String childPathSegment) {
        this.checkValidPathSegment(childPathSegment);
        this.path = parentPath.path + '/' + NodePath.encode(childPathSegment);
    }

    public NodePath child(String childNodeName) {
        return new NodePath(this, childNodeName);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NodePath)) {
            return false;
        }
        return this.path.equals(((NodePath)obj).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path;
    }

    private void checkValidPathSegment(String pathSegment) {
        if (pathSegment == null || pathSegment.isEmpty()) {
            throw new IllegalArgumentException("Path segments must not be null and not empty.");
        }
    }

    public static String encode(String raw) {
        String encoded = raw.replace("%", "%2A");
        encoded = encoded.replace("/", "%2F");
        return encoded;
    }

    public static String decode(String encoded) {
        String raw = encoded.replace("%2F", "/");
        raw = raw.replace("%2A", "%");
        return raw;
    }
}

