/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.client;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.talend.esb.servicelocator.client.BindingType;
import org.talend.esb.servicelocator.client.Endpoint;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.ServiceLocatorException;
import org.talend.esb.servicelocator.client.TransportType;
import org.talend.esb.servicelocator.client.ws.addressing.AttributedURIType;
import org.talend.esb.servicelocator.client.ws.addressing.EndpointReferenceType;
import org.talend.esb.servicelocator.client.ws.addressing.MetadataType;
import org.talend.esb.servicelocator.client.ws.addressing.ObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SimpleEndpoint
implements Endpoint {
    public static final Logger LOG = Logger.getLogger(SimpleEndpoint.class.getName());
    public static final ObjectFactory WSA_OBJECT_FACTORY = new ObjectFactory();
    private String addr;
    private BindingType binding;
    private TransportType transport;
    private SLProperties props;
    private QName sName;

    public SimpleEndpoint(QName serviceName, String endpoint) {
        this(serviceName, endpoint, null);
    }

    public SimpleEndpoint(QName serviceName, String endpoint, SLProperties properties) {
        this(serviceName, endpoint, BindingType.SOAP11, TransportType.HTTP, properties);
    }

    public SimpleEndpoint(QName serviceName, String endpoint, BindingType bindingType, TransportType transportType, SLProperties properties) {
        this.sName = serviceName;
        this.addr = endpoint;
        this.binding = bindingType;
        this.transport = transportType;
        this.props = properties;
    }

    protected SimpleEndpoint() {
    }

    protected void init(QName serviceName, String endpoint, BindingType bindingType, TransportType transportType, SLProperties properties) {
        this.sName = serviceName;
        this.addr = endpoint;
        this.props = properties;
        this.binding = bindingType;
        this.transport = transportType;
    }

    @Override
    public BindingType getBinding() {
        return this.binding;
    }

    @Override
    public TransportType getTransport() {
        return this.transport;
    }

    @Override
    public String getAddress() {
        return this.addr;
    }

    @Override
    public SLProperties getProperties() {
        return this.props;
    }

    public QName forService() {
        return this.sName;
    }

    @Override
    public QName getServiceName() {
        return this.forService();
    }

    @Override
    public void writeEndpointReferenceTo(Result result, Endpoint.PropertiesTransformer transformer) throws ServiceLocatorException {
        EndpointReferenceType epr = this.createEndpointReference(transformer);
        try {
            JAXBElement<EndpointReferenceType> ep = WSA_OBJECT_FACTORY.createEndpointReference(epr);
            ClassLoader cl = this.getClass().getClassLoader();
            JAXBContext jc = JAXBContext.newInstance((String)"org.talend.esb.servicelocator.client.ws.addressing:org.talend.esb.servicelocator.client.internal.endpoint", (ClassLoader)cl);
            Marshaller m = jc.createMarshaller();
            m.marshal(ep, result);
        }
        catch (JAXBException e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Failed to serialize endpoint data", e);
            }
            throw new ServiceLocatorException("Failed to serialize endpoint data", e);
        }
    }

    @Override
    public void addEndpointReference(Node parent) throws ServiceLocatorException {
        EndpointReferenceType wsAddr = this.createEndpointReference(null);
        try {
            JAXBElement<EndpointReferenceType> ep = WSA_OBJECT_FACTORY.createEndpointReference(wsAddr);
            ClassLoader cl = this.getClass().getClassLoader();
            JAXBContext jc = JAXBContext.newInstance((String)"org.talend.esb.servicelocator.client.ws.addressing:org.talend.esb.servicelocator.client.internal.endpoint", (ClassLoader)cl);
            Marshaller m = jc.createMarshaller();
            m.marshal(ep, parent);
        }
        catch (JAXBException e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Failed to serialize endpoint data", e);
            }
            throw new ServiceLocatorException("Failed to serialize endpoint data", e);
        }
    }

    private EndpointReferenceType createEndpointReference(Endpoint.PropertiesTransformer transformer) {
        AttributedURIType endpoint = new AttributedURIType();
        endpoint.setValue(this.addr);
        EndpointReferenceType epr = new EndpointReferenceType();
        epr.setAddress(endpoint);
        if (this.props != null) {
            DOMResult result = new DOMResult();
            transformer.writePropertiesTo(this.props, result);
            Document docResult = (Document)result.getNode();
            MetadataType metadata = new MetadataType();
            epr.setMetadata(metadata);
            metadata.getAny().add(docResult.getDocumentElement());
        }
        return epr;
    }
}

