/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.client.internal;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.talend.esb.servicelocator.client.BindingType;
import org.talend.esb.servicelocator.client.SLEndpoint;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.SLPropertiesImpl;
import org.talend.esb.servicelocator.client.SimpleEndpoint;
import org.talend.esb.servicelocator.client.TransportType;
import org.talend.esb.servicelocator.client.internal.SLPropertiesConverter;
import org.talend.esb.servicelocator.client.internal.endpoint.EndpointDataType;
import org.talend.esb.servicelocator.client.internal.endpoint.ObjectFactory;
import org.talend.esb.servicelocator.client.internal.endpoint.ServiceLocatorPropertiesType;
import org.talend.esb.servicelocator.client.ws.addressing.EndpointReferenceType;
import org.talend.esb.servicelocator.client.ws.addressing.MetadataType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SLEndpointProvider
extends SimpleEndpoint
implements SLEndpoint {
    public static final Logger LOG = Logger.getLogger(SLEndpointProvider.class.getName());
    public static final org.talend.esb.servicelocator.client.ws.addressing.ObjectFactory WSA_OBJECT_FACTORY = new org.talend.esb.servicelocator.client.ws.addressing.ObjectFactory();
    public static final ObjectFactory SL_OBJECT_FACTORY = new ObjectFactory();
    private static final String SERVICE_LOCATOR_PROPERTIES_NS = "http://talend.org/schemas/esb/locator/content/20011/11";
    private static final String SERVICE_LOCATOR_PROPERTIES_LN = "ServiceLocatorProperties";
    private Element eprRoot;
    private long lastTimeStarted = -1L;
    private long lastTimeStopped = -1L;
    private boolean isLive;

    public SLEndpointProvider(QName serviceName, EndpointDataType endpointData, boolean live) {
        this.eprRoot = endpointData.getEndpointReference();
        EndpointReferenceType epr = this.toEndPointReference(this.eprRoot);
        this.init(serviceName, this.extractAddress(epr), this.extractBinding(endpointData), this.extractTransport(endpointData), this.extractProperties(epr));
        this.lastTimeStarted = endpointData.getLastTimeStarted();
        this.lastTimeStopped = endpointData.getLastTimeStopped();
        this.isLive = live;
    }

    @Override
    public long getLastTimeStarted() {
        return this.lastTimeStarted;
    }

    @Override
    public long getLastTimeStopped() {
        return this.lastTimeStopped;
    }

    @Override
    public boolean isLive() {
        return this.isLive;
    }

    private EndpointReferenceType toEndPointReference(Element root) {
        EndpointReferenceType epr = null;
        if (root != null) {
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                JAXBContext jc = JAXBContext.newInstance((String)"org.talend.esb.servicelocator.client.ws.addressing", (ClassLoader)cl);
                Unmarshaller um = jc.createUnmarshaller();
                JAXBElement eprElem = (JAXBElement)um.unmarshal((Node)root);
                epr = (EndpointReferenceType)eprElem.getValue();
            }
            catch (JAXBException e) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Failed to deserialize endpoint reference", e);
                }
            }
        } else {
            LOG.log(Level.SEVERE, "No endpoint reference found in content");
        }
        return epr != null ? epr : new EndpointReferenceType();
    }

    private String extractAddress(EndpointReferenceType epr) {
        return epr.getAddress() != null ? epr.getAddress().getValue() : null;
    }

    private BindingType extractBinding(EndpointDataType epd) {
        return epd.getBinding() != null ? BindingType.fromValue(epd.getBinding().value()) : null;
    }

    private TransportType extractTransport(EndpointDataType epd) {
        return epd.getTransport() != null ? TransportType.fromValue(epd.getTransport().value()) : null;
    }

    private SLProperties extractProperties(EndpointReferenceType epr) {
        MetadataType metadata = epr.getMetadata();
        if (metadata != null) {
            List<Object> metaAny = metadata.getAny();
            for (Object any : metaAny) {
                Element root;
                if (!(any instanceof Element) || !this.isServiceLocatorProperties(root = (Element)any)) continue;
                ServiceLocatorPropertiesType slp = this.toServiceLocatorProperties(root);
                return SLPropertiesConverter.toSLProperties(slp);
            }
        }
        return new SLPropertiesImpl();
    }

    private ServiceLocatorPropertiesType toServiceLocatorProperties(Element root) {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            JAXBContext jc = JAXBContext.newInstance((String)"org.talend.esb.servicelocator.client.internal.endpoint", (ClassLoader)cl);
            Unmarshaller um = jc.createUnmarshaller();
            JAXBElement slp = (JAXBElement)um.unmarshal((Node)root);
            return (ServiceLocatorPropertiesType)slp.getValue();
        }
        catch (JAXBException e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Failed to deserialize service locator properties", e);
            }
            return SL_OBJECT_FACTORY.createServiceLocatorPropertiesType();
        }
    }

    private boolean isServiceLocatorProperties(Element elem) {
        return SERVICE_LOCATOR_PROPERTIES_LN.equals(elem.getLocalName()) && SERVICE_LOCATOR_PROPERTIES_NS.equals(elem.getNamespaceURI());
    }
}

