/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.client.internal;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.talend.esb.servicelocator.client.Endpoint;
import org.talend.esb.servicelocator.client.SLEndpoint;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.SLPropertiesMatcher;
import org.talend.esb.servicelocator.client.ServiceLocator;
import org.talend.esb.servicelocator.client.ServiceLocatorException;
import org.talend.esb.servicelocator.client.SimpleEndpoint;
import org.talend.esb.servicelocator.client.internal.EndpointTransformer;
import org.talend.esb.servicelocator.client.internal.EndpointTransformerImpl;
import org.talend.esb.servicelocator.client.internal.NodePath;

public class ServiceLocatorImpl
implements ServiceLocator {
    public static final NodePath LOCATOR_ROOT_PATH = new NodePath("cxf-locator");
    public static final String LIVE = "live";
    public static final byte[] EMPTY_CONTENT = new byte[0];
    public static final ServiceLocator.PostConnectAction DO_NOTHING_ACTION = new ServiceLocator.PostConnectAction(){

        @Override
        public void process(ServiceLocator lc) {
        }
    };
    private static final Logger LOG = Logger.getLogger(ServiceLocatorImpl.class.getName());
    private static final NodePathBinder<NodePath> IDENTICAL_BINDER = new NodePathBinder<NodePath>(){

        @Override
        public NodePath bind(NodePath nodepath) {
            return nodepath;
        }
    };
    private static final NodePathBinder<String> TO_NAME_BINDER = new NodePathBinder<String>(){

        @Override
        public String bind(NodePath nodePath) {
            return nodePath.getNodeName();
        }
    };
    private static final NodePathBinder<QName> TO_SERVICENAME_BINDER = new NodePathBinder<QName>(){

        @Override
        public QName bind(NodePath nodePath) {
            return QName.valueOf(nodePath.getNodeName());
        }
    };
    private String locatorEndpoints = "localhost:2181";
    private int sessionTimeout = 5000;
    private int connectionTimeout = 5000;
    private ServiceLocator.PostConnectAction postConnectAction = DO_NOTHING_ACTION;
    private volatile ZooKeeper zk;
    private EndpointTransformer transformer = new EndpointTransformerImpl();

    @Override
    public synchronized void connect() throws InterruptedException, ServiceLocatorException {
        this.disconnect();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Start connect session");
        }
        CountDownLatch connectionLatch = new CountDownLatch(1);
        this.zk = this.createZooKeeper(connectionLatch);
        boolean connected = connectionLatch.await(this.connectionTimeout, TimeUnit.MILLISECONDS);
        if (!connected) {
            throw new ServiceLocatorException("Connection to Service Locator failed.");
        }
        this.postConnectAction.process(this);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "End connect session");
        }
    }

    @Override
    public synchronized void disconnect() throws InterruptedException, ServiceLocatorException {
        if (this.zk != null) {
            this.zk.close();
            this.zk = null;
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Disconnected service locator session.");
            }
        }
    }

    @Override
    public synchronized void register(QName serviceName, String endpoint) throws ServiceLocatorException, InterruptedException {
        this.register(new SimpleEndpoint(serviceName, endpoint), false);
    }

    @Override
    public synchronized void register(QName serviceName, String endpoint, boolean persistent) throws ServiceLocatorException, InterruptedException {
        this.register(new SimpleEndpoint(serviceName, endpoint), persistent);
    }

    @Override
    public void register(QName serviceName, String endpoint, SLProperties properties) throws ServiceLocatorException, InterruptedException {
        this.register(new SimpleEndpoint(serviceName, endpoint, properties), false);
    }

    @Override
    public void register(QName serviceName, String endpoint, SLProperties properties, boolean persistent) throws ServiceLocatorException, InterruptedException {
        this.register(new SimpleEndpoint(serviceName, endpoint, properties), persistent);
    }

    @Override
    public synchronized void register(Endpoint epProvider) throws ServiceLocatorException, InterruptedException {
        this.register(epProvider, false);
    }

    @Override
    public synchronized void register(Endpoint epProvider, boolean persistent) throws ServiceLocatorException, InterruptedException {
        byte[] content;
        QName serviceName = epProvider.getServiceName();
        String endpoint = epProvider.getAddress();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Registering endpoint " + endpoint + " for service " + serviceName + "...");
        }
        this.checkConnection();
        long lastTimeStarted = System.currentTimeMillis();
        long lastTimeStopped = -1L;
        NodePath serviceNodePath = this.ensureServiceExists(serviceName);
        NodePath endpointNodePath = serviceNodePath.child(endpoint);
        try {
            if (this.nodeExists(endpointNodePath)) {
                content = this.getContent(endpointNodePath);
                SLEndpoint oldEndpoint = this.transformer.toSLEndpoint(serviceName, content, false);
                lastTimeStopped = oldEndpoint.getLastTimeStopped();
            }
        }
        catch (KeeperException e) {
            throw this.locatorException((Exception)((Object)e));
        }
        content = this.createContent(epProvider, lastTimeStarted, lastTimeStopped);
        endpointNodePath = this.ensureEndpointExists(serviceNodePath, endpoint, content);
        this.createEndpointStatus(endpointNodePath, persistent);
    }

    @Override
    public synchronized void unregister(Endpoint epProvider) throws ServiceLocatorException, InterruptedException {
        QName serviceName = epProvider.getServiceName();
        String endpoint = epProvider.getAddress();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Unregistering endpoint " + endpoint + " for service " + serviceName + "...");
        }
        this.checkConnection();
        long lastTimeStarted = -1L;
        long lastTimeStopped = System.currentTimeMillis();
        NodePath serviceNodePath = LOCATOR_ROOT_PATH.child(serviceName.toString());
        NodePath endpointNodePath = serviceNodePath.child(endpoint);
        try {
            if (this.nodeExists(endpointNodePath)) {
                byte[] oldContent = this.getContent(endpointNodePath);
                SLEndpoint oldEndpoint = this.transformer.toSLEndpoint(serviceName, oldContent, false);
                lastTimeStarted = oldEndpoint.getLastTimeStarted();
                NodePath endpointStatusNodePath = endpointNodePath.child(LIVE);
                this.ensurePathDeleted(endpointStatusNodePath, false);
                byte[] content = this.createContent(epProvider, lastTimeStarted, lastTimeStopped);
                this.setNodeData(endpointNodePath, content);
            }
        }
        catch (KeeperException e) {
            throw this.locatorException((Exception)((Object)e));
        }
    }

    @Override
    public synchronized void unregister(QName serviceName, String endpoint) throws ServiceLocatorException, InterruptedException {
        this.unregister(new SimpleEndpoint(serviceName, endpoint, null));
    }

    @Override
    public synchronized void removeEndpoint(QName serviceName, String endpoint) throws ServiceLocatorException, InterruptedException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Removing endpoint " + endpoint + " for service " + serviceName + "...");
        }
        this.checkConnection();
        NodePath serviceNodePath = LOCATOR_ROOT_PATH.child(serviceName.toString());
        NodePath endpointNodePath = serviceNodePath.child(endpoint);
        NodePath endpointStatusNodePath = endpointNodePath.child(LIVE);
        this.ensurePathDeleted(endpointStatusNodePath, false);
        this.ensurePathDeleted(endpointNodePath, false);
    }

    @Override
    public List<QName> getServices() throws InterruptedException, ServiceLocatorException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Getting all services...");
        }
        this.checkConnection();
        try {
            return this.getChildren(LOCATOR_ROOT_PATH, TO_SERVICENAME_BINDER);
        }
        catch (KeeperException e) {
            throw this.locatorException((Exception)((Object)e));
        }
    }

    @Override
    public List<SLEndpoint> getEndpoints(final QName serviceName) throws ServiceLocatorException, InterruptedException {
        NodePathBinder<SLEndpoint> slEndpointBinder = new NodePathBinder<SLEndpoint>(){

            @Override
            public SLEndpoint bind(NodePath nodePath) throws ServiceLocatorException, InterruptedException {
                try {
                    byte[] content = ServiceLocatorImpl.this.getContent(nodePath);
                    boolean isLive = ServiceLocatorImpl.this.isLive(nodePath);
                    return ServiceLocatorImpl.this.transformer.toSLEndpoint(serviceName, content, isLive);
                }
                catch (KeeperException e) {
                    throw ServiceLocatorImpl.this.locatorException((Exception)((Object)e));
                }
            }
        };
        this.checkConnection();
        try {
            NodePath servicePath = LOCATOR_ROOT_PATH.child(serviceName.toString());
            if (this.nodeExists(servicePath)) {
                return this.getChildren(servicePath, slEndpointBinder);
            }
            return Collections.emptyList();
        }
        catch (KeeperException e) {
            throw this.locatorException((Exception)((Object)e));
        }
    }

    @Override
    public SLEndpoint getEndpoint(QName serviceName, String endpoint) throws ServiceLocatorException, InterruptedException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Get endpoint information for endpoint " + endpoint + " within service " + serviceName + "...");
        }
        this.checkConnection();
        try {
            NodePath servicePath = LOCATOR_ROOT_PATH.child(serviceName.toString());
            NodePath endpointPath = servicePath.child(endpoint);
            if (this.nodeExists(endpointPath)) {
                byte[] content = this.getContent(endpointPath);
                boolean isLive = this.isLive(endpointPath);
                return this.transformer.toSLEndpoint(serviceName, content, isLive);
            }
            return null;
        }
        catch (KeeperException e) {
            throw this.locatorException((Exception)((Object)e));
        }
    }

    @Override
    public synchronized List<String> getEndpointNames(QName serviceName) throws ServiceLocatorException, InterruptedException {
        List<String> children;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Get all endpoint names of service " + serviceName + "...");
        }
        this.checkConnection();
        try {
            NodePath servicePath = LOCATOR_ROOT_PATH.child(serviceName.toString());
            if (this.nodeExists(servicePath)) {
                children = this.getChildren(servicePath, TO_NAME_BINDER);
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Lookup of service " + serviceName + " failed, service is not known.");
                }
                children = Collections.emptyList();
            }
        }
        catch (KeeperException e) {
            throw this.locatorException((Exception)((Object)e));
        }
        return children;
    }

    @Override
    public List<String> lookup(QName serviceName) throws ServiceLocatorException, InterruptedException {
        return this.lookup(serviceName, SLPropertiesMatcher.ALL_MATCHER);
    }

    @Override
    public synchronized List<String> lookup(QName serviceName, SLPropertiesMatcher matcher) throws ServiceLocatorException, InterruptedException {
        ArrayList<String> liveEndpoints;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Looking up endpoints of service " + serviceName + "...");
        }
        this.checkConnection();
        try {
            NodePath providerPath = LOCATOR_ROOT_PATH.child(serviceName.toString());
            if (this.nodeExists(providerPath)) {
                liveEndpoints = new ArrayList();
                List<NodePath> childNodePaths = this.getChildren(providerPath, IDENTICAL_BINDER);
                for (NodePath childNodePath : childNodePaths) {
                    byte[] content;
                    SLEndpoint endpoint;
                    SLProperties props;
                    if (!this.isLive(childNodePath) || !matcher.isMatching(props = (endpoint = this.transformer.toSLEndpoint(serviceName, content = this.getContent(childNodePath), true)).getProperties())) continue;
                    liveEndpoints.add(childNodePath.getNodeName());
                }
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Lookup of service " + serviceName + " failed, service is not known.");
                }
                liveEndpoints = Collections.emptyList();
            }
        }
        catch (KeeperException e) {
            throw this.locatorException((Exception)((Object)e));
        }
        return liveEndpoints;
    }

    public void setLocatorEndpoints(String endpoints) {
        this.locatorEndpoints = endpoints;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Locator endpoints set to " + this.locatorEndpoints);
        }
    }

    public void setSessionTimeout(int timeout) {
        this.sessionTimeout = timeout;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Locator session timeout set to: " + this.sessionTimeout);
        }
    }

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Locator connection timeout set to: " + this.connectionTimeout);
        }
    }

    public void setEndpointTransformer(EndpointTransformer endpointTransformer) {
        this.transformer = endpointTransformer;
    }

    @Override
    public void setPostConnectAction(ServiceLocator.PostConnectAction postConnectAction) {
        this.postConnectAction = postConnectAction;
    }

    private boolean isConnected() {
        return this.zk != null && this.zk.getState().equals((Object)ZooKeeper.States.CONNECTED);
    }

    private void checkConnection() throws ServiceLocatorException, InterruptedException {
        if (!this.isConnected()) {
            this.connect();
        }
    }

    private void ensurePathExists(NodePath path, CreateMode mode) throws ServiceLocatorException, InterruptedException {
        block7: {
            try {
                if (!this.nodeExists(path)) {
                    this.createNode(path, mode, EMPTY_CONTENT);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Node " + path + " created.");
                    }
                } else if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Node " + path + " already exists.");
                }
            }
            catch (KeeperException e) {
                if (!e.code().equals((Object)KeeperException.Code.NODEEXISTS)) {
                    throw this.locatorException((Exception)((Object)e));
                }
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.fine("Some other client created node" + path + " concurrently.");
            }
        }
    }

    private NodePath ensureServiceExists(QName serviceName) throws ServiceLocatorException, InterruptedException {
        NodePath serviceNodePath = LOCATOR_ROOT_PATH.child(serviceName.toString());
        this.ensurePathExists(serviceNodePath, CreateMode.PERSISTENT);
        return serviceNodePath;
    }

    private void createEndpointStatus(NodePath endpointNodePath, boolean persistent) throws ServiceLocatorException, InterruptedException {
        block3: {
            NodePath endpointStatusNodePath = endpointNodePath.child(LIVE);
            try {
                CreateMode mode = persistent ? CreateMode.PERSISTENT : CreateMode.EPHEMERAL;
                this.createNode(endpointStatusNodePath, mode, EMPTY_CONTENT);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Node " + endpointStatusNodePath + " created.");
                }
            }
            catch (KeeperException e) {
                if (e.code().equals((Object)KeeperException.Code.NODEEXISTS)) break block3;
                throw this.locatorException((Exception)((Object)e));
            }
        }
    }

    private NodePath ensureEndpointExists(NodePath serviceNodePath, String endpoint, byte[] content) throws ServiceLocatorException, InterruptedException {
        NodePath endpointNodePath = serviceNodePath.child(endpoint);
        try {
            if (!this.nodeExists(endpointNodePath)) {
                this.createNode(endpointNodePath, CreateMode.PERSISTENT, content);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Endpoint " + endpoint + " created with data:");
                    LOG.fine(new String(content, "utf-8"));
                }
            } else {
                this.setNodeData(endpointNodePath, content);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Node " + endpoint + " already exists, updated content with data:");
                    LOG.fine(new String(content, "utf-8"));
                }
            }
        }
        catch (KeeperException e) {
            throw this.locatorException((Exception)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            throw this.locatorException(e);
        }
        return endpointNodePath;
    }

    private void ensurePathDeleted(NodePath path, boolean canHaveChildren) throws ServiceLocatorException, InterruptedException {
        try {
            if (this.deleteNode(path, canHaveChildren)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Node " + path + " deteted.");
                }
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Node " + path + " cannot be deleted because it has children.");
            }
        }
        catch (KeeperException e) {
            if (e.code().equals((Object)KeeperException.Code.NONODE)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Node" + path + " already deleted.");
                }
            }
            throw this.locatorException((Exception)((Object)e));
        }
    }

    private boolean nodeExists(NodePath path) throws KeeperException, InterruptedException {
        return this.zk.exists(path.toString(), false) != null;
    }

    private void createNode(NodePath path, CreateMode mode, byte[] content) throws KeeperException, InterruptedException {
        this.zk.create(path.toString(), content, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
    }

    private void setNodeData(NodePath path, byte[] content) throws KeeperException, InterruptedException {
        this.zk.setData(path.toString(), content, -1);
    }

    private boolean deleteNode(NodePath path, boolean canHaveChildren) throws KeeperException, InterruptedException {
        try {
            this.zk.delete(path.toString(), -1);
            return true;
        }
        catch (KeeperException e) {
            if (e.code().equals((Object)KeeperException.Code.NOTEMPTY) && canHaveChildren) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Some other client created children nodes in the node" + path + " concurrently. Therefore, we can not delete it.");
                }
                return false;
            }
            throw e;
        }
    }

    private <T> List<T> getChildren(NodePath path, NodePathBinder<T> binder) throws ServiceLocatorException, KeeperException, InterruptedException {
        List encoded = this.zk.getChildren(path.toString(), false);
        ArrayList<T> boundChildren = new ArrayList<T>();
        for (String oneEncoded : encoded) {
            T boundChild = binder.bind(path.child(oneEncoded, true));
            boundChildren.add(boundChild);
        }
        return boundChildren;
    }

    private byte[] getContent(NodePath path) throws KeeperException, InterruptedException {
        return this.zk.getData(path.toString(), false, null);
    }

    private boolean isLive(NodePath endpointPath) throws KeeperException, InterruptedException {
        NodePath liveNodePath = endpointPath.child(LIVE);
        return this.nodeExists(liveNodePath);
    }

    private byte[] createContent(Endpoint eprProvider, long lastTimeStarted, long lastTimeStopped) throws ServiceLocatorException {
        return this.transformer.fromEndpoint(eprProvider, lastTimeStarted, lastTimeStopped);
    }

    private ServiceLocatorException locatorException(Exception e) {
        if (LOG.isLoggable(Level.SEVERE)) {
            LOG.log(Level.SEVERE, "The service locator server signaled an error", e);
        }
        return new ServiceLocatorException("The service locator server signaled an error.", e);
    }

    protected ZooKeeper createZooKeeper(CountDownLatch connectionLatch) throws ServiceLocatorException {
        try {
            return new ZooKeeper(this.locatorEndpoints, this.sessionTimeout, (Watcher)new WatcherImpl(connectionLatch));
        }
        catch (IOException e) {
            throw new ServiceLocatorException("At least one of the endpoints " + this.locatorEndpoints + " does not represent a valid address.");
        }
    }

    public class WatcherImpl
    implements Watcher {
        private CountDownLatch connectionLatch;

        public WatcherImpl(CountDownLatch connectionLatch) {
            this.connectionLatch = connectionLatch;
        }

        public void process(WatchedEvent event) {
            block8: {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Event with state " + event.getState() + " sent.");
                }
                Watcher.Event.KeeperState eventState = event.getState();
                try {
                    if (eventState == Watcher.Event.KeeperState.SyncConnected) {
                        ServiceLocatorImpl.this.ensurePathExists(LOCATOR_ROOT_PATH, CreateMode.PERSISTENT);
                        this.connectionLatch.countDown();
                    } else if (eventState == Watcher.Event.KeeperState.Expired) {
                        ServiceLocatorImpl.this.connect();
                    }
                }
                catch (InterruptedException e) {
                    if (LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "An InterruptedException was thrown while waiting for an answer from theService Locator", e);
                    }
                }
                catch (ServiceLocatorException e) {
                    if (!LOG.isLoggable(Level.SEVERE)) break block8;
                    LOG.log(Level.SEVERE, "Failed to execute an request to Service Locator.", e);
                }
            }
        }
    }

    private static interface NodePathBinder<T> {
        public T bind(NodePath var1) throws ServiceLocatorException, InterruptedException;
    }
}

