/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.talend.esb.servicelocator.client.SLPropertiesImpl;
import org.talend.esb.servicelocator.client.SLPropertiesMatcher;
import org.talend.esb.servicelocator.cxf.internal.ServiceLocatorManager;

public class LocatorFeature
extends AbstractFeature {
    private static final Logger LOG = Logger.getLogger(LocatorFeature.class.getName());
    private SLPropertiesImpl slProps;
    private SLPropertiesMatcher slPropsMatcher;
    private String selectionStrategy;

    public void initialize(Bus bus) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initializing Locator feature for bus " + bus);
        }
        ServiceLocatorManager slm = (ServiceLocatorManager)bus.getExtension(ServiceLocatorManager.class);
        slm.listenForAllServers(bus);
        slm.listenForAllClients();
    }

    public void initialize(Client client, Bus bus) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initializing locator feature for bus " + bus + " and client " + client);
        }
        ServiceLocatorManager slm = (ServiceLocatorManager)bus.getExtension(ServiceLocatorManager.class);
        slm.enableClient(client, this.slPropsMatcher, this.selectionStrategy);
    }

    public void initialize(Server server, Bus bus) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initializing locator feature for bus " + bus + " and server " + server);
        }
        ServiceLocatorManager slm = (ServiceLocatorManager)bus.getExtension(ServiceLocatorManager.class);
        slm.registerServer(server, this.slProps, bus);
    }

    public void initialize(InterceptorProvider interceptorProvider, Bus bus) {
        if (interceptorProvider instanceof ClientConfiguration) {
            this.initialize((ClientConfiguration)interceptorProvider, bus);
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "Tried to initialize locator feature with unknown interceptor provider " + interceptorProvider);
        }
    }

    public void initialize(ClientConfiguration clientConf, Bus bus) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initializing locator feature for bus " + bus + " and client configuration" + clientConf);
        }
        ServiceLocatorManager slm = (ServiceLocatorManager)bus.getExtension(ServiceLocatorManager.class);
        slm.enableClient(clientConf, this.slPropsMatcher, this.selectionStrategy);
    }

    protected ServiceLocatorManager getLocatorManager(Bus bus) {
        return (ServiceLocatorManager)bus.getExtension(ServiceLocatorManager.class);
    }

    public void setAvailableEndpointProperties(Map<String, String> properties) {
        this.slProps = new SLPropertiesImpl();
        for (String key : properties.keySet()) {
            String valueList = properties.get(key);
            List<String> values = this.tokenize(valueList);
            this.slProps.addProperty(key, values);
        }
    }

    public void setRequiredEndpointProperties(Map<String, String> properties) {
        this.slPropsMatcher = new SLPropertiesMatcher();
        for (String key : properties.keySet()) {
            String valueList = properties.get(key);
            List<String> values = this.tokenize(valueList);
            for (String value : values) {
                this.slPropsMatcher.addAssertion(key, value);
            }
        }
    }

    public void setSelectionStrategy(String selectionStrategy) {
        this.selectionStrategy = selectionStrategy;
    }

    List<String> tokenize(String valueList) {
        String[] values;
        ArrayList<String> normalizedValues = new ArrayList<String>();
        for (String value : values = valueList.split(",")) {
            normalizedValues.add(value.trim());
        }
        return normalizedValues;
    }
}

