/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf.internal;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.ConduitSelector;
import org.talend.esb.servicelocator.client.SLPropertiesMatcher;
import org.talend.esb.servicelocator.client.ServiceLocator;
import org.talend.esb.servicelocator.cxf.internal.LocatorSelectionStrategy;
import org.talend.esb.servicelocator.cxf.internal.LocatorTargetSelector;

public class LocatorClientEnabler {
    private static final Logger LOG = Logger.getLogger(LocatorClientEnabler.class.getPackage().getName());
    private static final String DEFAULT_STRATEGY = "defaultSelectionStrategy";
    private ServiceLocator locatorClient;
    private Bus bus;
    private Map<String, LocatorSelectionStrategy> locatorSelectionStrategies;
    private LocatorSelectionStrategy locatorSelectionStrategy;
    private String defaultLocatorSelectionStrategy;

    public void setServiceLocator(ServiceLocator locatorClient) {
        this.locatorClient = locatorClient;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Locator client " + locatorClient + " was set for LocatorClientRegistrar.");
        }
    }

    public void setBus(Bus bus) {
        this.bus = bus;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Bus " + bus + " was set for LocatorClientRegistrar.");
        }
    }

    public void setLocatorSelectionStrategies(Map<String, LocatorSelectionStrategy> locatorSelectionStrategies) {
        this.locatorSelectionStrategies = locatorSelectionStrategies;
        this.locatorSelectionStrategy = locatorSelectionStrategies.get(DEFAULT_STRATEGY);
    }

    public void setLocatorSelectionStrategy(String locatorSelectionStrategy) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Strategy " + locatorSelectionStrategy + " was set for LocatorClientRegistrar.");
        }
        if (this.locatorSelectionStrategies.containsKey(locatorSelectionStrategy)) {
            this.locatorSelectionStrategy = this.locatorSelectionStrategies.get(locatorSelectionStrategy);
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "LocatorSelectionStrategy " + locatorSelectionStrategy + " not registered at LocatorClientEnabler.");
        }
    }

    public void setDefaultLocatorSelectionStrategy(String defaultLocatorSelectionStrategy) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Default strategy " + defaultLocatorSelectionStrategy + " was set for LocatorClientRegistrar.");
        }
        if (this.locatorSelectionStrategies.containsKey(defaultLocatorSelectionStrategy)) {
            this.locatorSelectionStrategy = this.locatorSelectionStrategies.get(defaultLocatorSelectionStrategy);
            this.defaultLocatorSelectionStrategy = defaultLocatorSelectionStrategy;
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "Default LocatorSelectionStrategy " + defaultLocatorSelectionStrategy + " not registered at LocatorClientEnabler.");
        }
    }

    public void enable(ConduitSelectorHolder conduitSelectorHolder) {
        this.enable(conduitSelectorHolder, null);
    }

    public void enable(ConduitSelectorHolder conduitSelectorHolder, SLPropertiesMatcher matcher) {
        this.enable(conduitSelectorHolder, matcher, null);
    }

    public void enable(ConduitSelectorHolder conduitSelectorHolder, SLPropertiesMatcher matcher, String selectionStrategy) {
        LocatorTargetSelector selector = new LocatorTargetSelector();
        selector.setEndpoint(conduitSelectorHolder.getConduitSelector().getEndpoint());
        if (selectionStrategy != null) {
            this.setLocatorSelectionStrategy(selectionStrategy);
        } else {
            this.setLocatorSelectionStrategy(this.defaultLocatorSelectionStrategy);
        }
        this.locatorSelectionStrategy.setServiceLocator(this.locatorClient);
        if (matcher != null) {
            this.locatorSelectionStrategy.setMatcher(matcher);
        }
        selector.setLocatorSelectionStrategy(this.locatorSelectionStrategy);
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Client enabled with strategy " + this.locatorSelectionStrategy.getClass().getName() + ".");
        }
        conduitSelectorHolder.setConduitSelector((ConduitSelector)selector);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Successfully enabled client " + conduitSelectorHolder + " for the service locator");
        }
    }

    public static interface ConduitSelectorHolder {
        public ConduitSelector getConduitSelector();

        public void setConduitSelector(ConduitSelector var1);
    }
}

