/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf.internal;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.endpoint.Server;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.ServiceLocator;
import org.talend.esb.servicelocator.cxf.internal.SingleBusLocatorRegistrar;

public class LocatorRegistrar {
    private static final Logger LOG = Logger.getLogger(LocatorRegistrar.class.getPackage().getName());
    private ServiceLocator locatorClient;
    private String endpointPrefix = "";
    private Map<Bus, SingleBusLocatorRegistrar> busRegistrars = Collections.synchronizedMap(new LinkedHashMap());

    public void startListenForServers(Bus bus) {
        SingleBusLocatorRegistrar registrar = this.getRegistrar(bus);
        registrar.startListenForServers();
    }

    public void setEndpointPrefix(String endpointPrefix) {
        this.endpointPrefix = endpointPrefix != null ? endpointPrefix : "";
    }

    public void setServiceLocator(ServiceLocator locatorClient) {
        this.locatorClient = locatorClient;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Locator client was set.");
        }
    }

    public void registerServer(Server server, Bus bus) {
        this.registerServer(server, null, bus);
    }

    public void registerServer(Server server, SLProperties props, Bus bus) {
        SingleBusLocatorRegistrar registrar = this.getRegistrar(bus);
        registrar.registerServer(server, props);
    }

    private SingleBusLocatorRegistrar getRegistrar(Bus bus) {
        SingleBusLocatorRegistrar registrar = this.busRegistrars.get(bus);
        if (registrar == null) {
            this.check(this.locatorClient, "serviceLocator", "registerService");
            registrar = new SingleBusLocatorRegistrar(bus);
            registrar.setServiceLocator(this.locatorClient);
            registrar.setEndpointPrefix(this.endpointPrefix);
            this.busRegistrars.put(bus, registrar);
            this.addLifeCycleListener(bus);
        }
        return registrar;
    }

    private void addLifeCycleListener(final Bus bus) {
        BusLifeCycleManager manager = (BusLifeCycleManager)bus.getExtension(BusLifeCycleManager.class);
        manager.registerLifeCycleListener(new BusLifeCycleListener(){

            public void initComplete() {
            }

            public void preShutdown() {
            }

            public void postShutdown() {
                LocatorRegistrar.this.busRegistrars.remove(bus);
            }
        });
    }

    private void check(Object obj, String propertyName, String methodName) {
        if (obj == null) {
            throw new IllegalStateException("The property " + propertyName + " must be set before " + methodName + " can be called.");
        }
    }
}

