/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.clustering.FailoverTargetSelector;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.talend.esb.servicelocator.cxf.internal.DefaultSelectionStrategy;
import org.talend.esb.servicelocator.cxf.internal.LocatorSelectionStrategy;

public class LocatorTargetSelector
extends FailoverTargetSelector {
    private static final Logger LOG = Logger.getLogger(LocatorTargetSelector.class.getPackage().getName());
    private static final String LOCATOR_PROTOCOL = "locator://";
    private boolean locatorProtocol;
    private LocatorSelectionStrategy strategy = new DefaultSelectionStrategy();

    public LocatorTargetSelector(LocatorSelectionStrategy strategy) {
        this.setLocatorSelectionStrategy(strategy);
    }

    public LocatorTargetSelector() {
    }

    public synchronized void prepare(Message message) {
        Exchange exchange = message.getExchange();
        EndpointInfo ei = this.endpoint.getEndpointInfo();
        if (this.locatorProtocol || ei.getAddress().startsWith(LOCATOR_PROTOCOL)) {
            String physAddress;
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "Found address with locator protocol, mapping it to physical address.");
                LOG.log(Level.INFO, "Using strategy " + this.strategy.getClass().getName() + ".");
            }
            if ((physAddress = this.strategy.getPrimaryAddress(exchange)) != null) {
                ei.setAddress(physAddress);
                this.locatorProtocol = true;
                message.put((Object)Message.ENDPOINT_ADDRESS, (Object)physAddress);
            } else {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Failed to map logical locator address to physical address.");
                }
                throw new IllegalStateException("No endpoint found in Service Locator for service " + this.endpoint.getService().getName());
            }
        }
        super.prepare(message);
    }

    public void setLocatorSelectionStrategy(LocatorSelectionStrategy strategy) {
        this.strategy = strategy;
        this.setStrategy(strategy);
    }
}

