/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.client.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.talend.esb.servicelocator.client.Endpoint;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.ServiceLocatorException;
import org.talend.esb.servicelocator.client.internal.EndpointTransformer;
import org.talend.esb.servicelocator.client.internal.SLEndpointProvider;
import org.talend.esb.servicelocator.client.internal.SLPropertiesConverter;
import org.talend.esb.servicelocator.client.internal.endpoint.BindingType;
import org.talend.esb.servicelocator.client.internal.endpoint.EndpointDataType;
import org.talend.esb.servicelocator.client.internal.endpoint.ObjectFactory;
import org.talend.esb.servicelocator.client.internal.endpoint.ServiceLocatorPropertiesType;
import org.talend.esb.servicelocator.client.internal.endpoint.TransportType;
import org.w3c.dom.Document;

public class EndpointTransformerImpl
implements Endpoint.PropertiesTransformer,
EndpointTransformer {
    private static final Logger LOG = Logger.getLogger(EndpointTransformerImpl.class.getName());
    private static final ObjectFactory ENDPOINT_OBJECT_FACTORY = new ObjectFactory();

    @Override
    public SLEndpointProvider toSLEndpoint(QName serviceName, byte[] content, boolean isLive) {
        EndpointDataType epd = EndpointTransformerImpl.toEndPointData(content);
        return new SLEndpointProvider(serviceName, epd, isLive);
    }

    @Override
    public byte[] fromEndpoint(Endpoint endpoint, long lastTimeStarted, long lastTimeStopped) throws ServiceLocatorException {
        return this.serialize(this.createEndpointData(endpoint, lastTimeStarted, lastTimeStopped));
    }

    @Override
    public void writePropertiesTo(SLProperties props, Result result) {
        block2: {
            ServiceLocatorPropertiesType jaxbProps = SLPropertiesConverter.toServiceLocatorPropertiesType(props);
            try {
                JAXBElement<ServiceLocatorPropertiesType> elementProps = ENDPOINT_OBJECT_FACTORY.createServiceLocatorProperties(jaxbProps);
                this.createMarshaller().marshal(elementProps, result);
            }
            catch (JAXBException e) {
                if (!LOG.isLoggable(Level.SEVERE)) break block2;
                LOG.log(Level.SEVERE, "Failed to deserialize endpoint data", e);
            }
        }
    }

    private EndpointDataType createEndpointData(Endpoint eprProvider, long lastTimeStarted, long lastTimeStopped) throws ServiceLocatorException {
        EndpointDataType endpointData = ENDPOINT_OBJECT_FACTORY.createEndpointDataType();
        endpointData.setBinding(BindingType.fromValue(eprProvider.getBinding().getValue()));
        endpointData.setTransport(TransportType.fromValue(eprProvider.getTransport().getValue()));
        endpointData.setLastTimeStarted(lastTimeStarted);
        endpointData.setLastTimeStopped(lastTimeStopped);
        DOMResult result = new DOMResult();
        eprProvider.writeEndpointReferenceTo(result, this);
        Document doc = (Document)result.getNode();
        endpointData.setEndpointReference(doc.getDocumentElement());
        return endpointData;
    }

    private byte[] serialize(EndpointDataType endpointData) throws ServiceLocatorException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(50000);
        try {
            JAXBElement<EndpointDataType> epd = ENDPOINT_OBJECT_FACTORY.createEndpointData(endpointData);
            this.createMarshaller().marshal(epd, (OutputStream)outputStream);
        }
        catch (JAXBException e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Failed to serialize endpoint data", e);
            }
            throw new ServiceLocatorException("Failed to serialize endpoint data", e);
        }
        return outputStream.toByteArray();
    }

    public static EndpointDataType toEndPointData(byte[] content) {
        if (content == null) {
            throw new IllegalArgumentException("content must not be null.");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"org.talend.esb.servicelocator.client.internal.endpoint", (ClassLoader)EndpointTransformerImpl.class.getClassLoader());
            JAXBElement slEndpoint = (JAXBElement)jc.createUnmarshaller().unmarshal((InputStream)is);
            return (EndpointDataType)slEndpoint.getValue();
        }
        catch (JAXBException e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Failed to deserialize endpoint data", e);
            }
            EndpointDataType endpointData = ENDPOINT_OBJECT_FACTORY.createEndpointDataType();
            endpointData.setLastTimeStarted(-1L);
            endpointData.setLastTimeStopped(-1L);
            return endpointData;
        }
    }

    private Marshaller createMarshaller() throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"org.talend.esb.servicelocator.client.internal.endpoint", (ClassLoader)this.getClass().getClassLoader());
        return jc.createMarshaller();
    }
}

