/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf.internal;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.clustering.FailoverStrategy;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.talend.esb.servicelocator.client.SLPropertiesMatcher;
import org.talend.esb.servicelocator.client.ServiceLocator;
import org.talend.esb.servicelocator.client.ServiceLocatorException;

public abstract class LocatorSelectionStrategy
implements FailoverStrategy {
    protected static final Logger LOG = Logger.getLogger(LocatorSelectionStrategy.class.getName());
    protected Random random = new Random();
    private ServiceLocator serviceLocator;
    private SLPropertiesMatcher matcher = SLPropertiesMatcher.ALL_MATCHER;

    public String selectAlternateAddress(List<String> alternates) {
        String alternateAddress = null;
        if (alternates != null && !alternates.isEmpty()) {
            int index = this.random.nextInt(alternates.size());
            alternateAddress = alternates.remove(index);
        }
        return alternateAddress;
    }

    public List<Endpoint> getAlternateEndpoints(Exchange exchange) {
        return null;
    }

    public Endpoint selectAlternateEndpoint(List<Endpoint> alternates) {
        return null;
    }

    public abstract String getPrimaryAddress(Exchange var1);

    public void setMatcher(SLPropertiesMatcher propertiesMatcher) {
        if (propertiesMatcher != null) {
            this.matcher = propertiesMatcher;
        }
    }

    public void setServiceLocator(ServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public ServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    protected QName getServiceName(Exchange exchange) {
        return exchange.getEndpoint().getService().getName();
    }

    protected List<String> getEndpoints(QName serviceName) {
        List<String> endpoints;
        block4: {
            endpoints = Collections.emptyList();
            try {
                endpoints = this.serviceLocator.lookup(serviceName, this.matcher);
            }
            catch (ServiceLocatorException e) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Can not refresh list of endpoints due to ServiceLocatorException", e);
                }
            }
            catch (InterruptedException e) {
                if (!LOG.isLoggable(Level.SEVERE)) break block4;
                LOG.log(Level.SEVERE, "Can not refresh list of endpoints due to InterruptedException", e);
            }
        }
        return endpoints;
    }
}

