/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.apache.cxf.clustering.FailoverStrategy;
import org.apache.cxf.message.Exchange;
import org.talend.esb.servicelocator.cxf.internal.LocatorSelectionStrategy;

public class RandomSelectionStrategy
extends LocatorSelectionStrategy
implements FailoverStrategy {
    private int reloadAdressesCount = 10;
    private Map<QName, List<String>> availableAddressesMap = new HashMap<QName, List<String>>();
    private int reloadCounter;

    public void setReloadAdressesCount(int reloadAdressesCount) {
        this.reloadAdressesCount = reloadAdressesCount;
    }

    public List<String> getAlternateAddresses(Exchange exchange) {
        return this.getRotatedAdresses(this.getServiceName(exchange), true);
    }

    @Override
    public synchronized String getPrimaryAddress(Exchange exchange) {
        QName serviceName = this.getServiceName(exchange);
        String primaryAddress = null;
        List<String> availableAddresses = this.getRotatedAdresses(serviceName, false);
        if (!availableAddresses.isEmpty()) {
            primaryAddress = availableAddresses.get(0);
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Get address for service " + serviceName + " using strategy " + this.getClass().getName() + " selecting from " + availableAddresses + " selected = " + primaryAddress);
        }
        return primaryAddress;
    }

    private synchronized List<String> getRotatedAdresses(QName serviceName, boolean forceReload) {
        List<String> availableAddresses = this.availableAddressesMap.get(serviceName);
        if (forceReload || this.isReloadAdresses() || availableAddresses == null || availableAddresses.isEmpty()) {
            availableAddresses = this.getEndpoints(serviceName);
        }
        if (!availableAddresses.isEmpty()) {
            availableAddresses = this.getRotatedList(availableAddresses);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "List of endpoints for service " + serviceName + ": " + availableAddresses);
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Received empty list of endpoints from locator for service " + serviceName);
        }
        this.availableAddressesMap.put(serviceName, availableAddresses);
        return availableAddresses;
    }

    private List<String> getRotatedList(List<String> strings) {
        int index = this.random.nextInt(strings.size());
        ArrayList<String> rotated = new ArrayList<String>();
        for (int i = 0; i < strings.size(); ++i) {
            rotated.add(strings.get(index));
            index = (index + 1) % strings.size();
        }
        return rotated;
    }

    private synchronized boolean isReloadAdresses() {
        boolean isReloadAdresses = this.reloadCounter == 0;
        this.reloadCounter = (this.reloadCounter + 1) % this.reloadAdressesCount;
        return isReloadAdresses;
    }
}

