/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf.internal;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.ConduitSelector;
import org.talend.esb.servicelocator.client.SLPropertiesMatcher;
import org.talend.esb.servicelocator.client.ServiceLocator;
import org.talend.esb.servicelocator.cxf.internal.LocatorSelectionStrategy;
import org.talend.esb.servicelocator.cxf.internal.LocatorSelectionStrategyFactory;
import org.talend.esb.servicelocator.cxf.internal.LocatorTargetSelector;

public class LocatorClientEnabler {
    private static final Logger LOG = Logger.getLogger(LocatorClientEnabler.class.getPackage().getName());
    private static final String DEFAULT_STRATEGY = "defaultSelectionStrategy";
    private ServiceLocator locatorClient;
    private Map<String, LocatorSelectionStrategyFactory> locatorSelectionStrategies;
    private LocatorSelectionStrategyFactory locatorSelectionStrategyFactory;
    private String defaultLocatorSelectionStrategy;

    public void setServiceLocator(ServiceLocator serviceLocator) {
        this.locatorClient = serviceLocator;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Locator client " + serviceLocator + " was set for LocatorClientRegistrar.");
        }
    }

    public void setBus(Bus bus) {
    }

    public void setLocatorSelectionStrategies(Map<String, LocatorSelectionStrategyFactory> locatorSelectionStrategies) {
        this.locatorSelectionStrategies = locatorSelectionStrategies;
        this.locatorSelectionStrategyFactory = locatorSelectionStrategies.get(DEFAULT_STRATEGY);
    }

    public void setLocatorSelectionStrategy(String locatorSelectionStrategy) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Strategy " + locatorSelectionStrategy + " was set for LocatorClientRegistrar.");
        }
        if (this.locatorSelectionStrategies.containsKey(locatorSelectionStrategy)) {
            this.locatorSelectionStrategyFactory = this.locatorSelectionStrategies.get(locatorSelectionStrategy);
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "LocatorSelectionStrategy " + locatorSelectionStrategy + " not registered at LocatorClientEnabler.");
        }
    }

    public void setDefaultLocatorSelectionStrategy(String defaultLocatorSelectionStrategy) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Default strategy " + defaultLocatorSelectionStrategy + " was set for LocatorClientRegistrar.");
        }
        if (this.locatorSelectionStrategies.containsKey(defaultLocatorSelectionStrategy)) {
            this.locatorSelectionStrategyFactory = this.locatorSelectionStrategies.get(defaultLocatorSelectionStrategy);
            this.defaultLocatorSelectionStrategy = defaultLocatorSelectionStrategy;
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "Default LocatorSelectionStrategy " + defaultLocatorSelectionStrategy + " not registered at LocatorClientEnabler.");
        }
    }

    public void enable(ConduitSelectorHolder conduitSelectorHolder) {
        this.enable(conduitSelectorHolder, null);
    }

    public void enable(ConduitSelectorHolder conduitSelectorHolder, SLPropertiesMatcher matcher) {
        this.enable(conduitSelectorHolder, matcher, null);
    }

    public void enable(ConduitSelectorHolder conduitSelectorHolder, SLPropertiesMatcher matcher, String selectionStrategy) {
        LocatorTargetSelector selector = new LocatorTargetSelector();
        selector.setEndpoint(conduitSelectorHolder.getConduitSelector().getEndpoint());
        if (selectionStrategy != null) {
            this.setLocatorSelectionStrategy(selectionStrategy);
        } else {
            this.setLocatorSelectionStrategy(this.defaultLocatorSelectionStrategy);
        }
        LocatorSelectionStrategy locatorSelectionStrategy = this.locatorSelectionStrategyFactory.getInstance();
        locatorSelectionStrategy.setServiceLocator(this.locatorClient);
        if (matcher != null) {
            locatorSelectionStrategy.setMatcher(matcher);
        }
        selector.setLocatorSelectionStrategy(locatorSelectionStrategy);
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Client enabled with strategy " + locatorSelectionStrategy.getClass().getName() + ".");
        }
        conduitSelectorHolder.setConduitSelector((ConduitSelector)selector);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Successfully enabled client " + conduitSelectorHolder + " for the service locator");
        }
    }

    static interface ConduitSelectorHolder {
        public ConduitSelector getConduitSelector();

        public void setConduitSelector(ConduitSelector var1);
    }
}

