/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ConduitSelectorHolder;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.talend.esb.servicelocator.client.SLPropertiesImpl;
import org.talend.esb.servicelocator.client.SLPropertiesMatcher;
import org.talend.esb.servicelocator.cxf.internal.ServiceLocatorManager;

public class LocatorFeature
extends AbstractFeature {
    private static final Logger LOG = Logger.getLogger(LocatorFeature.class.getName());
    private SLPropertiesImpl slProps;
    private SLPropertiesMatcher slPropsMatcher;
    private String selectionStrategy;

    public void initialize(Bus bus) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initializing Locator feature for bus " + bus);
        }
        ServiceLocatorManager slm = (ServiceLocatorManager)bus.getExtension(ServiceLocatorManager.class);
        slm.listenForAllServers(bus);
        slm.listenForAllClients();
    }

    public void initialize(Client client, Bus bus) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initializing locator feature for bus " + bus + " and client " + client);
        }
        ServiceLocatorManager slm = (ServiceLocatorManager)bus.getExtension(ServiceLocatorManager.class);
        slm.enableClient(client, this.slPropsMatcher, this.selectionStrategy);
    }

    public void initialize(Server server, Bus bus) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initializing locator feature for bus " + bus + " and server " + server);
        }
        ServiceLocatorManager slm = (ServiceLocatorManager)bus.getExtension(ServiceLocatorManager.class);
        slm.registerServer(server, this.slProps, bus);
    }

    public void initialize(InterceptorProvider interceptorProvider, Bus bus) {
        if (interceptorProvider instanceof ConduitSelectorHolder) {
            this.initialize((ConduitSelectorHolder)interceptorProvider, bus);
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "Tried to initialize locator feature with unknown interceptor provider " + interceptorProvider);
        }
    }

    void initialize(ConduitSelectorHolder conduitSelectorHolder, Bus bus) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initializing locator feature for bus " + bus + " and client configuration" + conduitSelectorHolder);
        }
        ServiceLocatorManager slm = (ServiceLocatorManager)bus.getExtension(ServiceLocatorManager.class);
        slm.enableClient(conduitSelectorHolder, this.slPropsMatcher, this.selectionStrategy);
    }

    protected ServiceLocatorManager getLocatorManager(Bus bus) {
        return (ServiceLocatorManager)bus.getExtension(ServiceLocatorManager.class);
    }

    public void setAvailableEndpointProperties(Map<String, String> properties) {
        this.slProps = new SLPropertiesImpl();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.slProps.addProperty(entry.getKey(), this.tokenize(entry.getValue()));
        }
    }

    public void setRequiredEndpointProperties(Map<String, String> properties) {
        this.slPropsMatcher = new SLPropertiesMatcher();
        if (LOG.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            for (String prop : properties.keySet()) {
                sb.append(prop + " -> ");
                sb.append(properties.get(prop) + "\n");
            }
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            for (String value : this.tokenize(entry.getValue())) {
                this.slPropsMatcher.addAssertion(entry.getKey(), value);
            }
        }
        LOG.fine("set matcher = " + this.slPropsMatcher.toString());
        for (StackTraceElement trace : new Throwable().getStackTrace()) {
            LOG.fine(trace.toString());
        }
    }

    public void setSelectionStrategy(String selectionStrategy) {
        this.selectionStrategy = selectionStrategy;
    }

    Collection<String> tokenize(String valueList) {
        return Arrays.asList(valueList.split(","));
    }
}

