/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.client.internal.zk;

import org.apache.zookeeper.CreateMode;
import org.talend.esb.servicelocator.client.ServiceLocatorException;
import org.talend.esb.servicelocator.client.internal.EndpointNode;
import org.talend.esb.servicelocator.client.internal.NodePath;
import org.talend.esb.servicelocator.client.internal.zk.ServiceNodeImpl;
import org.talend.esb.servicelocator.client.internal.zk.ZKBackend;

public class EndpointNodeImpl
extends NodePath
implements EndpointNode {
    public static final String LIVE = "live";
    private ZKBackend zkBackend;

    public EndpointNodeImpl(ZKBackend backend, ServiceNodeImpl serviceNode, String endpointName) {
        super(serviceNode, endpointName.toString());
        this.zkBackend = backend;
    }

    @Override
    public String getEndpointName() {
        return this.getNodeName();
    }

    @Override
    public boolean exists() throws ServiceLocatorException, InterruptedException {
        return this.zkBackend.nodeExists(this);
    }

    @Override
    public void ensureExists(byte[] content) throws ServiceLocatorException, InterruptedException {
        this.zkBackend.ensurePathExists(this, CreateMode.PERSISTENT, content);
    }

    @Override
    public void ensureRemoved() throws ServiceLocatorException, InterruptedException {
        this.zkBackend.ensurePathDeleted(this.child(LIVE), false);
        this.zkBackend.ensurePathDeleted(this, true);
    }

    @Override
    public void setLive(boolean persistent) throws ServiceLocatorException, InterruptedException {
        CreateMode mode = persistent ? CreateMode.PERSISTENT : CreateMode.EPHEMERAL;
        NodePath endpointStatusNodePath = this.child(LIVE);
        this.zkBackend.ensurePathExists(endpointStatusNodePath, mode);
    }

    @Override
    public void setOffline() throws ServiceLocatorException, InterruptedException {
        NodePath endpointStatusNodePath = this.child(LIVE);
        this.zkBackend.ensurePathDeleted(endpointStatusNodePath, false);
    }

    @Override
    public byte[] getContent() throws ServiceLocatorException, InterruptedException {
        return this.zkBackend.getContent(this);
    }

    @Override
    public void setContent(byte[] content) throws ServiceLocatorException, InterruptedException {
        this.zkBackend.setNodeData(this, content);
    }

    @Override
    public boolean isLive() throws ServiceLocatorException, InterruptedException {
        return this.zkBackend.nodeExists(this.child(LIVE));
    }
}

