/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.clustering.FailoverTargetSelector;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.talend.esb.servicelocator.cxf.internal.DefaultSelectionStrategy;
import org.talend.esb.servicelocator.cxf.internal.LocatorSelectionStrategy;

public class LocatorTargetSelector
extends FailoverTargetSelector {
    private static final Logger LOG = Logger.getLogger(LocatorTargetSelector.class.getPackage().getName());
    private static final String LOCATOR_PROTOCOL = "locator://";
    private static final String LOCATOR_SETADDRESS_FLAG = "setAddress.called";
    private boolean locatorProtocol;
    private LocatorSelectionStrategy strategy = new DefaultSelectionStrategy();

    public void complete(Exchange exchange) {
        Exception ex;
        Message outMessage = exchange.getOutMessage();
        if (outMessage != null && (ex = (Exception)outMessage.getContent(Exception.class)) != null && exchange.get(Exception.class) == null) {
            exchange.put(Exception.class, (Object)ex);
        }
        super.complete(exchange);
    }

    public synchronized Conduit selectConduit(Message message) {
        this.setAddress(message);
        return super.selectConduit(message);
    }

    public synchronized void prepare(Message message) {
        this.setAddress(message);
        super.prepare(message);
    }

    protected void setAddress(Message message) {
        if (message.getExchange().get((Object)LOCATOR_SETADDRESS_FLAG) != Boolean.TRUE) {
            EndpointInfo ei = this.endpoint.getEndpointInfo();
            if (this.locatorProtocol || ei.getAddress().startsWith(LOCATOR_PROTOCOL)) {
                String physAddress;
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "Found address with locator protocol, mapping it to physical address.");
                    LOG.log(Level.INFO, "Using strategy " + this.strategy.getClass().getName() + ".");
                }
                if ((physAddress = this.strategy.getPrimaryAddress(message.getExchange())) != null) {
                    ei.setAddress(physAddress);
                    this.locatorProtocol = true;
                    message.put((Object)Message.ENDPOINT_ADDRESS, (Object)physAddress);
                } else {
                    if (LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "Failed to map logical locator address to physical address.");
                    }
                    throw new IllegalStateException("No endpoint found in Service Locator for service " + this.endpoint.getService().getName());
                }
            }
            message.getExchange().put((Object)LOCATOR_SETADDRESS_FLAG, (Object)Boolean.TRUE);
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Setting address was skipped. It was already applied for this message");
        }
    }

    public void setLocatorSelectionStrategy(LocatorSelectionStrategy locatorSelectionStrategy) {
        this.strategy = locatorSelectionStrategy;
        this.setStrategy(locatorSelectionStrategy);
    }
}

