/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.client.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.zookeeper.ZooKeeper;
import org.talend.esb.servicelocator.client.Endpoint;
import org.talend.esb.servicelocator.client.EndpointNotFoundException;
import org.talend.esb.servicelocator.client.ExpiredEndpointCollector;
import org.talend.esb.servicelocator.client.SLEndpoint;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.SLPropertiesMatcher;
import org.talend.esb.servicelocator.client.ServiceLocator;
import org.talend.esb.servicelocator.client.ServiceLocatorException;
import org.talend.esb.servicelocator.client.SimpleEndpoint;
import org.talend.esb.servicelocator.client.WrongArgumentException;
import org.talend.esb.servicelocator.client.internal.EndpointNode;
import org.talend.esb.servicelocator.client.internal.EndpointTransformer;
import org.talend.esb.servicelocator.client.internal.EndpointTransformerImpl;
import org.talend.esb.servicelocator.client.internal.RootNode;
import org.talend.esb.servicelocator.client.internal.ServiceLocatorBackend;
import org.talend.esb.servicelocator.client.internal.ServiceNode;
import org.talend.esb.servicelocator.client.internal.zk.ZKBackend;

public class ServiceLocatorImpl
implements ServiceLocator,
ExpiredEndpointCollector {
    private static final Logger LOG = Logger.getLogger(ServiceLocatorImpl.class.getName());
    private ServiceLocatorBackend backend;
    private EndpointTransformer transformer = new EndpointTransformerImpl();
    private Boolean endpointCollectionEnable;
    private Integer endpointCollectionInterval;
    private Timer timer;
    private int schedulerRequestCounter = 0;

    @Override
    public synchronized void connect() throws InterruptedException, ServiceLocatorException {
        this.getBackend().connect();
    }

    @Override
    public synchronized void disconnect() throws InterruptedException, ServiceLocatorException {
        this.getBackend().disconnect();
    }

    @Override
    public synchronized void register(QName serviceName, String endpoint) throws ServiceLocatorException, InterruptedException {
        this.register(new SimpleEndpoint(serviceName, endpoint), false);
    }

    @Override
    public synchronized void register(QName serviceName, String endpoint, boolean persistent) throws ServiceLocatorException, InterruptedException {
        this.register(new SimpleEndpoint(serviceName, endpoint), persistent);
    }

    @Override
    public void register(QName serviceName, String endpoint, SLProperties properties) throws ServiceLocatorException, InterruptedException {
        this.register(new SimpleEndpoint(serviceName, endpoint, properties), false);
    }

    @Override
    public void register(QName serviceName, String endpoint, SLProperties properties, boolean persistent) throws ServiceLocatorException, InterruptedException {
        this.register(new SimpleEndpoint(serviceName, endpoint, properties), persistent);
    }

    @Override
    public synchronized void register(Endpoint epProvider) throws ServiceLocatorException, InterruptedException {
        this.register(epProvider, false);
    }

    @Override
    public synchronized void register(Endpoint epProvider, boolean persistent) throws ServiceLocatorException, InterruptedException {
        byte[] content;
        QName serviceName = epProvider.getServiceName();
        String endpoint = epProvider.getAddress();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Registering endpoint " + endpoint + " for service " + serviceName + "...");
        }
        long lastTimeStarted = System.currentTimeMillis();
        long lastTimeStopped = -1L;
        RootNode rootNode = this.getBackend().connect();
        ServiceNode serviceNode = rootNode.getServiceNode(serviceName);
        serviceNode.ensureExists();
        EndpointNode endpointNode = serviceNode.getEndPoint(endpoint);
        if (endpointNode.exists()) {
            content = endpointNode.getContent();
            SLEndpoint oldEndpoint = this.transformer.toSLEndpoint(serviceName, content, false);
            lastTimeStopped = oldEndpoint.getLastTimeStopped();
        }
        content = this.createContent(epProvider, lastTimeStarted, lastTimeStopped);
        endpointNode.ensureExists(content);
        endpointNode.setLive(persistent);
    }

    @Override
    public synchronized void unregister(Endpoint epProvider) throws ServiceLocatorException, InterruptedException {
        QName serviceName = epProvider.getServiceName();
        String endpoint = epProvider.getAddress();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Unregistering endpoint " + endpoint + " for service " + serviceName + "...");
        }
        long lastTimeStarted = -1L;
        long lastTimeStopped = System.currentTimeMillis();
        RootNode rootNode = this.getBackend().connect();
        ServiceNode serviceNode = rootNode.getServiceNode(serviceName);
        EndpointNode endpointNode = serviceNode.getEndPoint(endpoint);
        if (endpointNode.exists()) {
            byte[] oldContent = endpointNode.getContent();
            SLEndpoint oldEndpoint = this.transformer.toSLEndpoint(serviceName, oldContent, false);
            lastTimeStarted = oldEndpoint.getLastTimeStarted();
            endpointNode.setOffline();
            byte[] content = this.createContent(epProvider, lastTimeStarted, lastTimeStopped);
            endpointNode.setContent(content);
        }
    }

    @Override
    public synchronized void unregister(QName serviceName, String endpoint) throws ServiceLocatorException, InterruptedException {
        this.unregister(new SimpleEndpoint(serviceName, endpoint, null));
    }

    @Override
    public void updateTimetolive(QName serviceName, String endpoint, int timetolive) throws ServiceLocatorException, InterruptedException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Updating expiring time to happen in " + timetolive + " seconds on endpoint " + endpoint + " for service " + serviceName + "...");
        }
        if (timetolive < 0) {
            throw new WrongArgumentException("Time-to-live cannot be negative.");
        }
        if (timetolive == 0) {
            throw new WrongArgumentException("Time-to-live cannot be zero.");
        }
        RootNode rootNode = this.getBackend().connect();
        ServiceNode serviceNode = rootNode.getServiceNode(serviceName);
        EndpointNode endpointNode = serviceNode.getEndPoint(endpoint);
        if (!endpointNode.exists()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Unable to update endpoint expiring time for endpoint " + endpoint + " for service " + serviceName + " because it does not exist.");
            }
            throw new EndpointNotFoundException("Endpoint " + endpoint + " for service " + serviceName + " does not exist.");
        }
        endpointNode.setExpiryTime(new Date(System.currentTimeMillis() + (long)(timetolive * 1000)), true);
    }

    @Override
    public synchronized void removeEndpoint(QName serviceName, String endpoint) throws ServiceLocatorException, InterruptedException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Removing endpoint " + endpoint + " for service " + serviceName + "...");
        }
        RootNode rootNode = this.getBackend().connect();
        ServiceNode serviceNode = rootNode.getServiceNode(serviceName);
        EndpointNode endpointNode = serviceNode.getEndPoint(endpoint);
        endpointNode.ensureRemoved();
    }

    @Override
    public List<QName> getServices() throws InterruptedException, ServiceLocatorException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Getting all services...");
        }
        RootNode rootNode = this.getBackend().connect();
        return rootNode.getServiceNames();
    }

    @Override
    public synchronized List<SLEndpoint> getEndpoints(QName serviceName) throws ServiceLocatorException, InterruptedException {
        RootNode rootNode = this.getBackend().connect();
        ServiceNode serviceNode = rootNode.getServiceNode(serviceName);
        if (serviceNode.exists()) {
            List<EndpointNode> endpointNodes = serviceNode.getEndPoints();
            ArrayList<SLEndpoint> slEndpoints = new ArrayList<SLEndpoint>(endpointNodes.size());
            for (EndpointNode endpointNode : endpointNodes) {
                byte[] content = endpointNode.getContent();
                boolean isLive = endpointNode.isLive();
                SLEndpoint slEndpoint = this.transformer.toSLEndpoint(serviceName, content, isLive);
                slEndpoints.add(slEndpoint);
            }
            return slEndpoints;
        }
        return Collections.emptyList();
    }

    @Override
    public SLEndpoint getEndpoint(QName serviceName, String endpoint) throws ServiceLocatorException, InterruptedException {
        RootNode rootNode;
        ServiceNode serviceNode;
        EndpointNode endpointNode;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Get endpoint information for endpoint " + endpoint + " within service " + serviceName + "...");
        }
        if ((endpointNode = (serviceNode = (rootNode = this.getBackend().connect()).getServiceNode(serviceName)).getEndPoint(endpoint)).exists()) {
            byte[] content = endpointNode.getContent();
            boolean isLive = endpointNode.isLive();
            return this.transformer.toSLEndpoint(serviceName, content, isLive);
        }
        return null;
    }

    @Override
    public synchronized List<String> getEndpointNames(QName serviceName) throws ServiceLocatorException, InterruptedException {
        List<String> children;
        RootNode rootNode;
        ServiceNode serviceNode;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Get all endpoint names of service " + serviceName + "...");
        }
        if ((serviceNode = (rootNode = this.getBackend().connect()).getServiceNode(serviceName)).exists()) {
            children = serviceNode.getEndpointNames();
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Lookup of service " + serviceName + " failed, service is not known.");
            }
            children = Collections.emptyList();
        }
        return children;
    }

    @Override
    public List<String> lookup(QName serviceName) throws ServiceLocatorException, InterruptedException {
        return this.lookup(serviceName, SLPropertiesMatcher.ALL_MATCHER);
    }

    @Override
    public synchronized List<String> lookup(QName serviceName, SLPropertiesMatcher matcher) throws ServiceLocatorException, InterruptedException {
        ArrayList<String> liveEndpoints;
        RootNode rootNode;
        ServiceNode serviceNode;
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Looking up endpoints of service " + serviceName + "...");
        }
        if ((serviceNode = (rootNode = this.getBackend().connect()).getServiceNode(serviceName)).exists()) {
            liveEndpoints = new ArrayList();
            List<EndpointNode> endpointNodes = serviceNode.getEndPoints();
            for (EndpointNode endpointNode : endpointNodes) {
                if (!endpointNode.isLive()) continue;
                byte[] content = endpointNode.getContent();
                SLEndpoint endpoint = this.transformer.toSLEndpoint(serviceName, content, true);
                SLProperties props = endpoint.getProperties();
                if (LOG.isLoggable(Level.INFO)) {
                    StringBuilder sb = new StringBuilder();
                    for (String prop : props.getPropertyNames()) {
                        sb.append(prop + " : ");
                        for (String value : props.getValues(prop)) {
                            sb.append(value + " ");
                        }
                        sb.append("\n");
                    }
                    LOG.info("Lookup of service " + serviceName + " props = " + sb.toString());
                    LOG.info("matcher = " + matcher.toString());
                }
                if (matcher.isMatching(props)) {
                    liveEndpoints.add(endpointNode.getEndpointName());
                    if (!LOG.isLoggable(Level.INFO)) continue;
                    LOG.info("matched =  " + endpointNode.getEndpointName());
                    continue;
                }
                if (!LOG.isLoggable(Level.INFO)) continue;
                LOG.info("not matched =  " + endpointNode.getEndpointName());
            }
        } else {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Lookup of service " + serviceName + " failed, service is not known.");
            }
            liveEndpoints = Collections.emptyList();
        }
        return liveEndpoints;
    }

    public void setLocatorEndpoints(String endpoints) {
        ((ZKBackend)this.getBackend()).setLocatorEndpoints(endpoints);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Locator endpoints set to " + endpoints);
        }
    }

    public void setSessionTimeout(int timeout) {
        ((ZKBackend)this.getBackend()).setSessionTimeout(timeout);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Locator session timeout set to: " + timeout);
        }
    }

    public void setConnectionTimeout(int timeout) {
        ((ZKBackend)this.getBackend()).setConnectionTimeout(timeout);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Locator connection timeout set to: " + timeout);
        }
    }

    public void setBackend(ServiceLocatorBackend backend) {
        this.backend = backend;
    }

    public void setName(String name) {
        ((ZKBackend)this.getBackend()).setUserName(name);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("User name set to: " + name);
        }
    }

    public void setPassword(String passWord) {
        ((ZKBackend)this.getBackend()).setPassword(passWord);
    }

    public void setEndpointTransformer(EndpointTransformer endpointTransformer) {
        this.transformer = endpointTransformer;
    }

    public void setEndpointCollectionEnable(Boolean endpointCollectionDisable) {
        this.endpointCollectionEnable = endpointCollectionDisable;
    }

    public void setEndpointCollectionInterval(Integer endpointCollectionInterval) {
        this.endpointCollectionInterval = endpointCollectionInterval;
    }

    @Override
    public void setPostConnectAction(ServiceLocator.PostConnectAction postConnectAction) {
        this.backend.setPostConnectAction(postConnectAction);
    }

    private byte[] createContent(Endpoint eprProvider, long lastTimeStarted, long lastTimeStopped) throws ServiceLocatorException {
        return this.transformer.fromEndpoint(eprProvider, lastTimeStarted, lastTimeStopped);
    }

    private ServiceLocatorBackend getBackend() {
        if (this.backend == null) {
            this.backend = new ZKBackend();
        }
        return this.backend;
    }

    protected ZooKeeper createZooKeeper(CountDownLatch connectionLatch) throws ServiceLocatorException {
        return null;
    }

    @Override
    public synchronized void startScheduledCollection() {
        if (this.endpointCollectionEnable != null && !this.endpointCollectionEnable.booleanValue()) {
            LOG.info("Expired endpoint collection is disabled in configuration.");
            return;
        }
        if (this.endpointCollectionInterval == null) {
            LOG.severe("Expired endpoint collection interval is not set.");
            return;
        }
        Long collectionInterval = (long)this.endpointCollectionInterval.intValue() * 1000L;
        if (collectionInterval < 5000L) {
            LOG.severe("Expired endpoint collection interval has invalid value '" + collectionInterval + "'. " + "It should be >= 5000.");
            return;
        }
        ++this.schedulerRequestCounter;
        if (this.timer != null) {
            return;
        }
        if (this.schedulerRequestCounter != 1) {
            LOG.warning("Expired endpoint collector schedule is inconsistent.");
        }
        this.timer = new Timer("Expired-Endpoint-Collector-Timer", true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ServiceLocatorImpl.this.performCollection();
            }
        }, collectionInterval, (long)collectionInterval);
    }

    @Override
    public synchronized void stopScheduledCollection() {
        if (this.timer == null) {
            return;
        }
        --this.schedulerRequestCounter;
        if (this.schedulerRequestCounter <= 0) {
            this.timer.cancel();
            this.timer = null;
            this.schedulerRequestCounter = 0;
        }
    }

    @Override
    public synchronized void performCollection() {
        LOG.fine("Performing expired endpoint collection.");
        Date now = new Date();
        try {
            RootNode root = this.getBackend().connect();
            List<QName> svcs = root.getServiceNames();
            for (QName svc : svcs) {
                ServiceNode svcNode = root.getServiceNode(svc);
                List<EndpointNode> epts = svcNode.getEndPoints();
                for (EndpointNode ept : epts) {
                    Date expTime = ept.getExpiryTime();
                    if (expTime == null || !expTime.before(now)) continue;
                    this.unregisterEndpoint(svc, ept.getEndpointName());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void unregisterEndpoint(QName serviceName, String endpointName) {
        try {
            this.unregister(serviceName, endpointName);
        }
        catch (Exception e) {
            if (e instanceof ServiceLocatorException || e instanceof InterruptedException) {
                LOG.warning("Exception during unregistering expired endpoint: " + e);
            }
            throw new RuntimeException("Unexpected exception during unregistering expired endpoint.", e);
        }
    }
}

