/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.MetadataType;
import org.apache.cxf.ws.addressing.ObjectFactory;
import org.apache.cxf.wsdl.WSAEndpointReferenceUtils;
import org.talend.esb.servicelocator.client.BindingType;
import org.talend.esb.servicelocator.client.Endpoint;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.SLPropertiesImpl;
import org.talend.esb.servicelocator.client.ServiceLocatorException;
import org.talend.esb.servicelocator.client.SimpleEndpoint;
import org.talend.esb.servicelocator.client.TransportType;
import org.talend.esb.servicelocator.client.internal.SLPropertiesConverter;
import org.talend.esb.servicelocator.client.internal.endpoint.ServiceLocatorPropertiesType;
import org.w3c.dom.Node;

public class CXFEndpointProvider
implements org.talend.esb.servicelocator.client.Endpoint {
    static final String SOAP11_BINDING_ID = "http://schemas.xmlsoap.org/wsdl/soap/";
    static final String SOAP12_BINDING_ID = "http://schemas.xmlsoap.org/wsdl/soap12/";
    static final String JAXRS_BINDING_ID = "http://apache.org/cxf/binding/jaxrs";
    static final String CXF_HTTP_TRANSPORT_ID = "http://cxf.apache.org/transports/http";
    static final String SOAP_HTTP_TRANSPORT_ID = "http://schemas.xmlsoap.org/soap/http";
    private static final Logger LOG = Logger.getLogger(CXFEndpointProvider.class.getName());
    private static final ObjectFactory WSA_OBJECT_FACTORY = new ObjectFactory();
    private static final org.talend.esb.servicelocator.client.internal.endpoint.ObjectFactory SL_OBJECT_FACTORY = new org.talend.esb.servicelocator.client.internal.endpoint.ObjectFactory();
    private static volatile JAXBContext jContext;
    private final QName sName;
    private final EndpointReferenceType epr;
    private final BindingType bindingType;
    private final TransportType transportType;
    private SLProperties props;

    public CXFEndpointProvider(QName serviceName, EndpointReferenceType endpointReference) {
        this(serviceName, null, null, endpointReference);
    }

    public CXFEndpointProvider(QName serviceName, String bindingId, String transportId, EndpointReferenceType endpointReference) {
        this.sName = serviceName;
        this.epr = endpointReference;
        this.bindingType = CXFEndpointProvider.map2BindingType(bindingId);
        this.transportType = CXFEndpointProvider.map2TransportType(transportId);
    }

    public CXFEndpointProvider(QName serviceName, String address, SLProperties properties) {
        this(serviceName, CXFEndpointProvider.createEPR(address, properties));
        this.props = properties;
    }

    public CXFEndpointProvider(Server server, String address, SLProperties properties) {
        this(CXFEndpointProvider.getServiceName(server), CXFEndpointProvider.getBindingId(server), CXFEndpointProvider.getTransportId(server), CXFEndpointProvider.createEPR(server, address, properties));
        this.props = properties;
    }

    @Override
    public QName getServiceName() {
        return this.sName;
    }

    @Override
    public String getAddress() {
        return this.epr.getAddress().getValue();
    }

    @Override
    public BindingType getBinding() {
        return this.bindingType;
    }

    @Override
    public TransportType getTransport() {
        return this.transportType;
    }

    @Override
    public SLProperties getProperties() {
        return this.props != null ? this.props : SLPropertiesImpl.EMPTY_PROPERTIES;
    }

    @Override
    public void writeEndpointReferenceTo(Result result, Endpoint.PropertiesTransformer transformer) throws ServiceLocatorException {
        try {
            JAXBElement ep = WSA_OBJECT_FACTORY.createEndpointReference(this.epr);
            this.createMarshaller().marshal((Object)ep, result);
        }
        catch (JAXBException e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Failed to serialize endpoint data", e);
            }
            throw new ServiceLocatorException("Failed to serialize endpoint data", e);
        }
    }

    @Override
    public void addEndpointReference(Node parent) throws ServiceLocatorException {
        this.serializeEPR(this.epr, parent);
    }

    private void serializeEPR(EndpointReferenceType wsAddr, Node parent) throws ServiceLocatorException {
        try {
            JAXBElement ep = WSA_OBJECT_FACTORY.createEndpointReference(wsAddr);
            this.createMarshaller().marshal((Object)ep, parent);
        }
        catch (JAXBException e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Failed to serialize endpoint data", e);
            }
            throw new ServiceLocatorException("Failed to serialize endpoint data", e);
        }
    }

    private Marshaller createMarshaller() throws JAXBException {
        JAXBContext jc = CXFEndpointProvider.getContext();
        return jc.createMarshaller();
    }

    private static JAXBContext getContext() throws JAXBException {
        if (jContext == null) {
            jContext = JAXBContext.newInstance((String)"org.apache.cxf.ws.addressing:org.talend.esb.servicelocator.client.internal.endpoint", (ClassLoader)SimpleEndpoint.class.getClassLoader());
        }
        return jContext;
    }

    public boolean equals(Object other) {
        if (other instanceof CXFEndpointProvider) {
            CXFEndpointProvider otherEndpoint = (CXFEndpointProvider)other;
            return this.getAddress().equals(otherEndpoint.getAddress()) && this.getServiceName().equals(otherEndpoint.getServiceName());
        }
        return false;
    }

    public int hashCode() {
        int result = 13;
        int c = this.getAddress().hashCode();
        result = 23 * result + c;
        c = this.getServiceName().hashCode();
        result = 23 * result + c;
        return c;
    }

    public String toString() {
        return "CXFEndpointProvider with address " + this.getAddress() + " for service " + this.getServiceName();
    }

    private static EndpointReferenceType createEPR(String address, SLProperties props) {
        EndpointReferenceType epr = WSAEndpointReferenceUtils.getEndpointReference((String)address);
        if (props != null) {
            CXFEndpointProvider.addProperties(epr, props);
        }
        return epr;
    }

    private static EndpointReferenceType createEPR(Server server, String address, SLProperties props) {
        EndpointReferenceType sourceEPR = server.getEndpoint().getEndpointInfo().getTarget();
        EndpointReferenceType targetEPR = WSAEndpointReferenceUtils.duplicate((EndpointReferenceType)sourceEPR);
        WSAEndpointReferenceUtils.setAddress((EndpointReferenceType)targetEPR, (String)address);
        if (props != null) {
            CXFEndpointProvider.addProperties(targetEPR, props);
        }
        return targetEPR;
    }

    private static void addProperties(EndpointReferenceType epr, SLProperties props) {
        MetadataType metadata = WSAEndpointReferenceUtils.getSetMetadata((EndpointReferenceType)epr);
        ServiceLocatorPropertiesType jaxbProps = SLPropertiesConverter.toServiceLocatorPropertiesType(props);
        JAXBElement<ServiceLocatorPropertiesType> slp = SL_OBJECT_FACTORY.createServiceLocatorProperties(jaxbProps);
        metadata.getAny().add(slp);
    }

    private static QName getServiceName(Server server) {
        QName serviceName;
        String bindingId = CXFEndpointProvider.getBindingId(server);
        EndpointInfo eInfo = server.getEndpoint().getEndpointInfo();
        if (JAXRS_BINDING_ID.equals(bindingId)) {
            serviceName = eInfo.getName();
        } else {
            ServiceInfo serviceInfo = eInfo.getService();
            serviceName = serviceInfo.getName();
        }
        return serviceName;
    }

    private static String getBindingId(Server server) {
        Endpoint ep = server.getEndpoint();
        BindingInfo bi = ep.getBinding().getBindingInfo();
        return bi.getBindingId();
    }

    private static String getTransportId(Server server) {
        return server.getEndpoint().getEndpointInfo().getTransportId();
    }

    private static BindingType map2BindingType(String bindingId) {
        BindingType type = SOAP11_BINDING_ID.equals(bindingId) ? BindingType.SOAP11 : (SOAP12_BINDING_ID.equals(bindingId) ? BindingType.SOAP12 : (JAXRS_BINDING_ID.equals(bindingId) ? BindingType.JAXRS : BindingType.OTHER));
        return type;
    }

    private static TransportType map2TransportType(String transportId) {
        TransportType type = CXF_HTTP_TRANSPORT_ID.equals(transportId) || SOAP_HTTP_TRANSPORT_ID.equals(transportId) ? TransportType.HTTP : TransportType.OTHER;
        return type;
    }
}

