/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.client.internal.zk;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.talend.esb.servicelocator.client.ServiceLocator;
import org.talend.esb.servicelocator.client.ServiceLocatorException;
import org.talend.esb.servicelocator.client.internal.NodePath;
import org.talend.esb.servicelocator.client.internal.RootNode;
import org.talend.esb.servicelocator.client.internal.ServiceLocatorBackend;
import org.talend.esb.servicelocator.client.internal.ServiceLocatorImpl;
import org.talend.esb.servicelocator.client.internal.zk.LocatorSettings;
import org.talend.esb.servicelocator.client.internal.zk.RootNodeImpl;
import org.talend.esb.servicelocator.client.internal.zk.ServiceLocatorACLs;

public class ZKBackend
implements ServiceLocatorBackend {
    public static final NodePath LOCATOR_ROOT_PATH = new NodePath("cxf-locator");
    public static final Charset UTF8_CHAR_SET = Charset.forName("UTF-8");
    private static final Logger LOG = Logger.getLogger(ServiceLocatorImpl.class.getName());
    private static final byte[] EMPTY_CONTENT = new byte[0];
    private Set<ServiceLocator.PostConnectAction> postConnectActions = new HashSet<ServiceLocator.PostConnectAction>();
    private boolean authentication;
    private LocatorSettings settings = new LocatorSettings();
    private volatile ZooKeeper zk;
    private RootNodeImpl rootNode = new RootNodeImpl(this);

    public ZKBackend() {
        this.settings.setEndpoints("localhost:2181");
    }

    @Override
    public RootNode connect() throws InterruptedException, ServiceLocatorException {
        if (!this.isConnected()) {
            boolean connected;
            this.disconnect();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Start connect session");
            }
            CountDownLatch connectionLatch = new CountDownLatch(1);
            this.zk = this.createZooKeeper(connectionLatch);
            if (this.authentication) {
                this.authenticate();
            }
            if (!(connected = connectionLatch.await(this.settings.getConnectionTimeout(), TimeUnit.MILLISECONDS))) {
                throw new ServiceLocatorException("Connection to Service Locator failed.");
            }
            for (ServiceLocator.PostConnectAction postConnectAction : this.postConnectActions) {
                postConnectAction.process(null);
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "End connect session");
            }
        }
        return this.rootNode;
    }

    @Override
    public void disconnect() throws InterruptedException, ServiceLocatorException {
        if (this.zk != null) {
            this.zk.close();
            this.zk = null;
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Disconnected service locator session.");
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.zk != null && this.zk.getState().equals((Object)ZooKeeper.States.CONNECTED);
    }

    public RootNode getRootNode() throws InterruptedException, ServiceLocatorException {
        this.connect();
        return this.rootNode;
    }

    public boolean nodeExists(NodePath path) throws ServiceLocatorException, InterruptedException {
        try {
            return this.zk.exists(path.toString(), false) != null;
        }
        catch (KeeperException e) {
            throw this.locatorException((Exception)((Object)e));
        }
    }

    public void createNode(NodePath path, CreateMode mode, byte[] content) throws KeeperException, InterruptedException {
        this.zk.create(path.toString(), content, this.getACLs(), mode);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Node " + path + " created as" + mode + "in ZooKeeper with content " + new String(content, UTF8_CHAR_SET));
        }
    }

    public void setNodeData(NodePath path, byte[] content) throws ServiceLocatorException, InterruptedException {
        try {
            this.zk.setData(path.toString(), content, -1);
        }
        catch (KeeperException e) {
            throw this.locatorException((Exception)((Object)e));
        }
    }

    public boolean deleteNode(NodePath path, boolean canHaveChildren) throws KeeperException, InterruptedException {
        try {
            this.zk.delete(path.toString(), -1);
            return true;
        }
        catch (KeeperException e) {
            if (e.code().equals((Object)KeeperException.Code.NOTEMPTY) && canHaveChildren) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Some other client created children nodes in the node" + path + " concurrently. Therefore, we can not delete it.");
                }
                return false;
            }
            throw e;
        }
    }

    public <T> List<T> getChildren(NodePath path, NodeMapper<T> mapper) throws ServiceLocatorException, InterruptedException {
        List encoded;
        try {
            encoded = this.zk.getChildren(path.toString(), false);
        }
        catch (KeeperException e) {
            throw this.locatorException((Exception)((Object)e));
        }
        ArrayList<T> boundChildren = new ArrayList<T>(encoded.size());
        for (String oneEncoded : encoded) {
            String notEncoded = NodePath.decode(oneEncoded);
            T boundChild = mapper.map(notEncoded);
            boundChildren.add(boundChild);
        }
        return boundChildren;
    }

    public byte[] getContent(NodePath path) throws ServiceLocatorException, InterruptedException {
        try {
            byte[] content = this.zk.getData(path.toString(), false, null);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Retrieved the following content for node " + path);
                LOG.fine(new String(content, UTF8_CHAR_SET));
            }
            return content;
        }
        catch (KeeperException e) {
            throw this.locatorException((Exception)((Object)e));
        }
    }

    public void ensurePathExists(NodePath path, CreateMode mode) throws ServiceLocatorException, InterruptedException {
        this.ensurePathExists(path, mode, EMPTY_CONTENT);
    }

    public void ensurePathExists(NodePath path, CreateMode mode, byte[] content) throws ServiceLocatorException, InterruptedException {
        block10: {
            try {
                if (!this.nodeExists(path)) {
                    this.createNode(path, mode, content);
                } else {
                    if (mode.isEphemeral()) {
                        this.deleteNode(path, false);
                        this.createNode(path, mode, content);
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Ephemeral node " + path + " was recreated.");
                        }
                    } else if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Node " + path + " already exists.");
                    }
                    if (!Arrays.equals(EMPTY_CONTENT, content) && content.length != 0) {
                        this.setNodeData(path, content);
                    }
                }
            }
            catch (KeeperException e) {
                if (!e.code().equals((Object)KeeperException.Code.NODEEXISTS)) {
                    throw this.locatorException((Exception)((Object)e));
                }
                if (!LOG.isLoggable(Level.FINE)) break block10;
                LOG.fine("Some other client created node" + path + " concurrently.");
            }
        }
    }

    public void ensurePathDeleted(NodePath path, boolean canHaveChildren) throws ServiceLocatorException, InterruptedException {
        try {
            if (this.deleteNode(path, canHaveChildren)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Node " + path + " deteted.");
                }
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Node " + path + " cannot be deleted because it has children.");
            }
        }
        catch (KeeperException e) {
            if (e.code().equals((Object)KeeperException.Code.NONODE)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Node" + path + " already deleted.");
                }
            }
            throw this.locatorException((Exception)((Object)e));
        }
    }

    @Override
    public void addPostConnectAction(ServiceLocator.PostConnectAction postConnectAction) {
        this.postConnectActions.add(postConnectAction);
    }

    @Override
    public void removePostConnectAction(ServiceLocator.PostConnectAction postConnectAction) {
        this.postConnectActions.remove(postConnectAction);
    }

    public void setLocatorEndpoints(String endpoints) {
        this.settings.setEndpoints(endpoints);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Locator endpoints set to " + this.settings.getEndpoints());
        }
    }

    public void setSessionTimeout(int timeout) {
        this.settings.setSessionTimeout(timeout);
    }

    public void setConnectionTimeout(int timeout) {
        this.settings.setConnectionTimeout(timeout);
    }

    public void setUserName(String userName) {
        this.settings.setUser(userName);
    }

    public void setPassword(String passWord) {
        this.settings.setPassword(passWord);
    }

    private void initializeRootNode() throws ServiceLocatorException, InterruptedException {
        this.rootNode.ensureExists();
        this.authentication = this.rootNode.isAuthenticationEnabled();
    }

    private void authenticate() throws ServiceLocatorException {
        if (this.settings.getUser() == null) {
            throw new ServiceLocatorException("Service Locator server requires authentication, but no user is defined.");
        }
        this.zk.addAuthInfo("sl", this.settings.getAuthInfo());
    }

    private List<ACL> getACLs() {
        return this.authentication ? ServiceLocatorACLs.LOCATOR_ACLS : ZooDefs.Ids.OPEN_ACL_UNSAFE;
    }

    protected ZooKeeper createZooKeeper(CountDownLatch connectionLatch) throws ServiceLocatorException {
        try {
            return new ZooKeeper(this.settings.getEndpoints(), this.settings.getSessionTimeout(), (Watcher)new WatcherImpl(connectionLatch));
        }
        catch (IOException e) {
            throw new ServiceLocatorException("A network failure occured when connecting to the ZooKeeper server", e);
        }
    }

    private ServiceLocatorException locatorException(Exception e) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "The service locator server signaled an error", e);
        }
        return new ServiceLocatorException("The service locator server signaled an error.", e);
    }

    public class WatcherImpl
    implements Watcher {
        private CountDownLatch connectionLatch;

        public WatcherImpl(CountDownLatch connectionLatch) {
            this.connectionLatch = connectionLatch;
        }

        public void process(WatchedEvent event) {
            block10: {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Event with state " + event.getState() + " sent.");
                }
                Watcher.Event.KeeperState eventState = event.getState();
                try {
                    if (eventState == Watcher.Event.KeeperState.SyncConnected) {
                        block9: {
                            try {
                                ZKBackend.this.initializeRootNode();
                            }
                            catch (ServiceLocatorException e) {
                                KeeperException zke = (KeeperException)e.getCause();
                                if (!zke.code().equals((Object)KeeperException.Code.NOAUTH)) break block9;
                                ZKBackend.this.authenticate();
                                ZKBackend.this.initializeRootNode();
                            }
                        }
                        this.connectionLatch.countDown();
                        break block10;
                    }
                    if (eventState == Watcher.Event.KeeperState.Expired) {
                        ZKBackend.this.connect();
                    }
                }
                catch (InterruptedException e) {
                    if (LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "An InterruptedException was thrown while waiting for an answer from theService Locator", e);
                    }
                }
                catch (ServiceLocatorException e) {
                    if (!LOG.isLoggable(Level.SEVERE)) break block10;
                    LOG.log(Level.SEVERE, "Failed to execute an request to Service Locator.", e);
                }
            }
        }
    }

    public static interface NodeMapper<T> {
        public T map(String var1) throws ServiceLocatorException, InterruptedException;
    }
}

