/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.endpoint.Server;
import org.springframework.beans.factory.annotation.Value;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.ServiceLocator;
import org.talend.esb.servicelocator.cxf.internal.SingleBusLocatorRegistrar;

@Named
@Singleton
public class LocatorRegistrar {
    private static final Logger LOG = Logger.getLogger(LocatorRegistrar.class.getPackage().getName());
    @Inject
    ServiceLocator locatorClient;
    @Value(value="${endpoint.prefix}")
    String endpointPrefix = "";
    @Value(value="${endpoint.http.prefix}")
    String endpointPrefixHttp;
    @Value(value="${endpoint.https.prefix}")
    String endpointPrefixHttps;
    private Map<Bus, SingleBusLocatorRegistrar> busRegistrars = Collections.synchronizedMap(new LinkedHashMap());

    public void startListenForServers(Bus bus) {
        SingleBusLocatorRegistrar registrar = this.getRegistrar(bus);
        registrar.startListenForServers();
    }

    public void setEndpointPrefix(String endpointPrefix) {
        this.endpointPrefix = endpointPrefix != null ? endpointPrefix : "";
    }

    public void setServiceLocator(ServiceLocator serviceLocator) {
        this.locatorClient = serviceLocator;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Locator client was set.");
        }
    }

    public void registerServer(Server server, Bus bus) {
        this.registerServer(server, null, bus);
    }

    public void registerServer(Server server, SLProperties props, Bus bus) {
        this.getRegistrar(bus).registerServer(server, props);
    }

    private SingleBusLocatorRegistrar getRegistrar(Bus bus) {
        SingleBusLocatorRegistrar registrar = this.busRegistrars.get(bus);
        if (registrar == null) {
            this.check(this.locatorClient, "serviceLocator", "registerService");
            registrar = new SingleBusLocatorRegistrar(bus);
            registrar.setServiceLocator(this.locatorClient);
            registrar.setEndpointPrefix(this.endpointPrefix);
            HashMap<String, String> endpointPrefixes = new HashMap<String, String>();
            endpointPrefixes.put("HTTP", this.endpointPrefixHttp);
            endpointPrefixes.put("HTTPS", this.endpointPrefixHttps);
            registrar.setEndpointPrefixes(endpointPrefixes);
            this.busRegistrars.put(bus, registrar);
            this.addLifeCycleListener(bus);
        }
        return registrar;
    }

    private void addLifeCycleListener(final Bus bus) {
        BusLifeCycleManager manager = (BusLifeCycleManager)bus.getExtension(BusLifeCycleManager.class);
        manager.registerLifeCycleListener(new BusLifeCycleListener(){

            public void initComplete() {
            }

            public void preShutdown() {
            }

            public void postShutdown() {
                LocatorRegistrar.this.locatorClient.removePostConnectAction((ServiceLocator.PostConnectAction)LocatorRegistrar.this.busRegistrars.get(bus));
                LocatorRegistrar.this.busRegistrars.remove(bus);
            }
        });
    }

    private void check(Object obj, String propertyName, String methodName) {
        if (obj == null) {
            throw new IllegalStateException("The property " + propertyName + " must be set before " + methodName + " can be called.");
        }
    }

    public void setEndpointPrefixHttp(String endpointPrefixHttp) {
        this.endpointPrefixHttp = endpointPrefixHttp;
    }

    public void setEndpointPrefixHttps(String endpointPrefixHttps) {
        this.endpointPrefixHttps = endpointPrefixHttps;
    }
}

