/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.ops4j.pax.cdi.api.OsgiServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.esb.servicelocator.cxf.internal.LocatorRegistrar;
import org.talend.esb.servicelocator.cxf.internal.SingleBusLocatorRegistrar;

@OsgiServiceProvider(classes={LifecycleStrategy.class})
@Named(value="locatorLifecycleStrategy")
@Singleton
public class LocatorLifecycleStrategy
extends LifecycleStrategySupport {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Inject
    LocatorRegistrar locatorRegistrar;

    public void onContextStop(CamelContext context) {
        this.stopAllServersAndRemoveCamelContext(context);
    }

    public void onEndpointAdd(Endpoint endpoint) {
        this.addCamelContextToRegistar(endpoint);
    }

    private void addCamelContextToRegistar(Endpoint endpoint) {
        Bus bus = null;
        try {
            JAXRSServerFactoryBean jaxrsServerFactoryBean;
            if (endpoint instanceof CxfEndpoint) {
                bus = ((CxfEndpoint)endpoint).getBus();
            } else if (endpoint instanceof CxfRsEndpoint && (jaxrsServerFactoryBean = (JAXRSServerFactoryBean)CamelContextHelper.lookup((CamelContext)endpoint.getCamelContext(), (String)((CxfRsEndpoint)endpoint).getBeanId(), JAXRSServerFactoryBean.class)) != null) {
                bus = jaxrsServerFactoryBean.getBus();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bus != null) {
            this.log.debug("Linking bus={} with {}" + bus.getId(), (Object)endpoint.getCamelContext());
            this.locatorRegistrar.getRegistrar(bus).setCamelContext(endpoint.getCamelContext());
        }
    }

    private void stopAllServersAndRemoveCamelContext(CamelContext camelContext) {
        this.log.debug("Stopping all servers associated with {}", (Object)camelContext);
        List<SingleBusLocatorRegistrar> registrars = this.locatorRegistrar.getAllRegistars(camelContext);
        registrars.forEach(registrar -> registrar.stopAllServersAndRemoveCamelContext());
    }
}

