/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.locator.server.init.internal;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.talend.esb.locator.server.init.internal.RootNodeACLs;

public class RootNodeInitializer
implements Watcher {
    private static final Charset UTF8_CHAR_SET = Charset.forName("UTF-8");
    private static final String ZK_ROOT_NODE_PATH = "/";
    private static final String ROOT_NODE_PATH = "/cxf-locator";
    private static final Logger LOG = Logger.getLogger(RootNodeInitializer.class.getName());
    private int timeout = 10000;
    private String locatorEndpoints = "localhost:2181";
    private String version = "5.2.0";
    private boolean authentication;
    private ZooKeeper zk;
    private CountDownLatch finishedLatch = new CountDownLatch(1);

    public void setLocatorEndpoints(String endpoints) {
        this.locatorEndpoints = endpoints;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Locator endpoints set to " + this.locatorEndpoints);
        }
    }

    public void setLocatorPort(String port) {
        this.locatorEndpoints = "localhost:" + port;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Locator endpoint set to " + this.locatorEndpoints);
        }
    }

    public void setVersion(String versionNumber) {
        this.version = versionNumber;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Version set to " + this.version);
        }
    }

    public void setAuthentication(boolean auth) {
        this.authentication = auth;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("authentication is " + this.authentication);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws InterruptedException {
        try {
            this.zk = new ZooKeeper(this.locatorEndpoints, 5000, (Watcher)this);
            boolean finished = this.finishedLatch.await(this.timeout, TimeUnit.MILLISECONDS);
            if (!finished && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Failed to connect to ZooKeeper and initialize the root node within " + this.timeout + " ms.");
            }
        }
        catch (IOException e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Failed to create ZooKeeper client", e);
            }
        }
        finally {
            this.stop();
        }
    }

    public void stop() throws InterruptedException {
        if (this.zk != null) {
            this.zk.close();
            this.zk = null;
        }
    }

    public void process(WatchedEvent event) {
        Watcher.Event.KeeperState eventState = event.getState();
        if (eventState == Watcher.Event.KeeperState.SyncConnected) {
            this.createRootNode();
        } else if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Connect to ZooKeeper failed. ZooKeeper client returned state " + eventState);
        }
    }

    private void createRootNode() {
        block9: {
            try {
                Stat stat = this.zk.exists(ROOT_NODE_PATH, false);
                if (stat == null) {
                    this.zk.create(ROOT_NODE_PATH, this.getContent(), this.getLocatorRootACLs(), CreateMode.PERSISTENT);
                    this.zk.setACL(ZK_ROOT_NODE_PATH, this.getZKRootACLs(), -1);
                    break block9;
                }
                try {
                    byte[] oldContent = this.zk.getData(ROOT_NODE_PATH, false, new Stat());
                    if (this.contentNeedsUpdate(oldContent)) {
                        this.zk.setData(ROOT_NODE_PATH, this.getContent(), -1);
                        this.zk.setACL(ROOT_NODE_PATH, this.getLocatorRootACLs(), -1);
                        this.zk.setACL(ZK_ROOT_NODE_PATH, this.getZKRootACLs(), -1);
                    }
                }
                catch (KeeperException e) {
                    if (!e.code().equals((Object)KeeperException.Code.NOAUTH)) break block9;
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.log(Level.INFO, "Service Locator already requires authentication. Configuration settings for the Service Locator root cannot be applied anymore.");
                        break block9;
                    }
                    throw e;
                }
            }
            catch (KeeperException e) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Failed to create RootNode", e);
                }
            }
            catch (InterruptedException e) {
                if (!LOG.isLoggable(Level.SEVERE)) break block9;
                LOG.log(Level.SEVERE, "Thread got interrupted when wating for root node to be created.", e);
            }
        }
        this.finishedLatch.countDown();
    }

    private byte[] getContent() {
        String contentAsStr = this.version + "," + Boolean.toString(this.authentication);
        return contentAsStr.getBytes(UTF8_CHAR_SET);
    }

    private boolean contentNeedsUpdate(byte[] oldContent) {
        String oldVersion = null;
        boolean oldAuthentication = false;
        String contentStr = new String(oldContent, UTF8_CHAR_SET);
        String[] parts = contentStr.split(",");
        if (parts.length == 2) {
            oldVersion = parts[0];
            oldAuthentication = Boolean.parseBoolean(parts[1]);
            return !oldAuthentication && this.authentication || !oldVersion.equals(this.version);
        }
        return false;
    }

    private List<ACL> getLocatorRootACLs() {
        return this.authentication ? RootNodeACLs.LOCATOR_ROOT_ACLS : ZooDefs.Ids.OPEN_ACL_UNSAFE;
    }

    private List<ACL> getZKRootACLs() {
        return this.authentication ? RootNodeACLs.ZK_ROOT_ACLS : ZooDefs.Ids.OPEN_ACL_UNSAFE;
    }
}

