/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.locator.zookeeper.server;

import java.io.IOException;
import java.util.Properties;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.admin.AdminServer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.talend.esb.locator.zookeeper.server.ZookeeperServer;

public class ZookeeperServerImpl
implements ZookeeperServer {
    ZookeeperServer serverInner;

    private ZookeeperServerImpl() {
    }

    public static ZookeeperServer getZookeeperServer(Properties props) throws Exception {
        QuorumPeerConfig config = new QuorumPeerConfig();
        config.parseProperties(props);
        if (config.getServers().size() > 0) {
            return new MyQuorumPeerMain(config);
        }
        return new MyZooKeeperServerMain(config);
    }

    @Override
    public void startup() throws IOException, AdminServer.AdminServerException {
        this.serverInner.startup();
    }

    @Override
    public void shutdown() {
        this.serverInner.shutdown();
    }

    static class MyZooKeeperServerMain
    extends ZooKeeperServerMain
    implements ZookeeperServer {
        private final QuorumPeerConfig config;

        MyZooKeeperServerMain(QuorumPeerConfig config) {
            this.config = config;
        }

        @Override
        public void startup() throws IOException, AdminServer.AdminServerException {
            ServerConfig serverConfig = new ServerConfig();
            serverConfig.readFrom(this.config);
            this.runFromConfig(serverConfig);
        }

        @Override
        public void shutdown() {
            super.shutdown();
        }
    }

    static class MyQuorumPeerMain
    extends QuorumPeerMain
    implements ZookeeperServer {
        private final QuorumPeerConfig config;

        MyQuorumPeerMain(QuorumPeerConfig config) {
            this.config = config;
        }

        @Override
        public void startup() throws IOException, AdminServer.AdminServerException {
            this.runFromConfig(this.config);
        }

        @Override
        public void shutdown() {
            if (null != this.quorumPeer) {
                this.quorumPeer.shutdown();
            }
        }
    }
}

