/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.locator.zookeeper.server;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.server.admin.AdminServer;
import org.talend.esb.locator.zookeeper.server.ZookeeperServer;
import org.talend.esb.locator.zookeeper.server.ZookeeperServerImpl;

public class ZookeeperServerManager
implements ZookeeperServer {
    private static final Logger LOG = Logger.getLogger(ZookeeperServerManager.class.getName());
    private ZookeeperServer main;
    private Thread zkMainThread;
    private Dictionary<?, ?> properties;

    public void setProperties(Dictionary<?, ?> properties) {
        this.properties = properties;
    }

    @Override
    public void startup() {
        Dictionary<?, ?> dict = this.properties;
        LOG.info("Staring up ZooKeeper server");
        if (dict == null) {
            LOG.info("Ignoring configuration update because updated configuration is empty.");
            this.shutdown();
            return;
        }
        if (this.main != null) {
            this.shutdown();
        }
        if (dict.get("clientPort") == null) {
            LOG.info("Ignoring configuration update because required property 'clientPort' isn't set.");
            return;
        }
        Properties props = new Properties();
        Enumeration<?> e = dict.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (key instanceof String) {
                String skey = (String)key;
                if (skey.startsWith("zookeeper.admin.")) {
                    System.setProperty(skey, dict.get(skey).toString());
                    continue;
                }
                props.put(skey, dict.get(skey));
                continue;
            }
            props.put(key, dict.get(key));
        }
        try {
            this.main = ZookeeperServerImpl.getZookeeperServer(props);
            this.zkMainThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ZookeeperServerManager.this.main.startup();
                    }
                    catch (IOException | AdminServer.AdminServerException e) {
                        LOG.log(Level.SEVERE, "Problem running ZooKeeper server.", e);
                    }
                }
            });
            this.zkMainThread.start();
            LOG.info("Applied configuration update :" + props);
        }
        catch (Exception th) {
            LOG.log(Level.SEVERE, "Problem applying configuration update: " + props, th);
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.main != null) {
            LOG.info("Shutting down ZooKeeper server");
            this.main.shutdown();
            try {
                this.zkMainThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.main = null;
            this.zkMainThread = null;
        }
    }
}

