/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.policy.transformation;

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.talend.esb.policy.transformation.TransformationAssertion;
import org.talend.esb.policy.transformation.TransformationPolicyBuilder;
import org.talend.esb.policy.transformation.TransformationType;

public abstract class AbstractTransformationPolicyInterceptor
extends AbstractPhaseInterceptor<Message> {
    protected static final String XSLT_PATH = "org.talend.esb.transformation.xslt-path";
    protected static final String TRANSFORM_MAP = "org.talend.esb.transformation.transform-map";

    public AbstractTransformationPolicyInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) {
        AssertionInfo ai = null;
        try {
            ai = TransformationPolicyBuilder.getAssertion(message);
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
        if (ai == null || !(ai.getAssertion() instanceof TransformationAssertion)) {
            return;
        }
        TransformationAssertion tas = (TransformationAssertion)ai.getAssertion();
        TransformationType transformationType = tas.getTransformationType();
        if (transformationType == TransformationType.xslt) {
            this.proceedXSLT(message, tas);
        } else if (transformationType == TransformationType.simple) {
            this.proceedSimple(message, tas);
        }
        if (ai != null) {
            ai.setAsserted(true);
        }
    }

    protected abstract void proceedXSLT(Message var1, TransformationAssertion var2);

    protected abstract void proceedSimple(Message var1, TransformationAssertion var2);

    protected boolean shouldSchemaValidate(Message message, TransformationAssertion.MessageType msgType, TransformationAssertion.AppliesToType appliesToType) {
        if (MessageUtils.isRequestor((Message)message)) {
            if (MessageUtils.isOutbound((Message)message)) {
                return !(appliesToType != TransformationAssertion.AppliesToType.consumer && appliesToType != TransformationAssertion.AppliesToType.always || msgType != TransformationAssertion.MessageType.request && msgType != TransformationAssertion.MessageType.all);
            }
            return !(appliesToType != TransformationAssertion.AppliesToType.consumer && appliesToType != TransformationAssertion.AppliesToType.always || msgType != TransformationAssertion.MessageType.response && msgType != TransformationAssertion.MessageType.all);
        }
        if (MessageUtils.isOutbound((Message)message)) {
            return !(appliesToType != TransformationAssertion.AppliesToType.provider && appliesToType != TransformationAssertion.AppliesToType.always || msgType != TransformationAssertion.MessageType.response && msgType != TransformationAssertion.MessageType.all);
        }
        return !(appliesToType != TransformationAssertion.AppliesToType.provider && appliesToType != TransformationAssertion.AppliesToType.always || msgType != TransformationAssertion.MessageType.request && msgType != TransformationAssertion.MessageType.all);
    }
}

