/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.policy.transformation;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.Assertion;
import org.apache.neethi.PolicyComponent;
import org.talend.esb.policy.transformation.TransformationPolicyBuilder;
import org.talend.esb.policy.transformation.TransformationType;
import org.w3c.dom.Element;

public class TransformationAssertion
implements Assertion {
    private static final String NS_PREFIX = "tpa";
    private static final String TYPE_NAME = "type";
    private static final String PATH_ATTRIBUTE_NAME = "path";
    private static final String APPLIES_TO_ATTRIBUTE_NAME = "appliesTo";
    private static final String MESSAGE_TYPE_ATTRIBUTE_NAME = "message";
    private final TransformationType transformationType;
    private final String path;
    private final String appliesTo;
    private final String messageType;

    public TransformationAssertion(Element element) {
        String sType = element.getAttribute(TYPE_NAME);
        this.transformationType = sType == null || sType.isEmpty() ? TransformationType.xslt : TransformationType.valueOf(sType);
        this.path = element.getAttribute(PATH_ATTRIBUTE_NAME);
        this.appliesTo = element.getAttribute(APPLIES_TO_ATTRIBUTE_NAME);
        this.messageType = element.getAttribute(MESSAGE_TYPE_ATTRIBUTE_NAME);
    }

    public short getType() {
        return 5;
    }

    public boolean equal(PolicyComponent policyComponent) {
        return policyComponent == this;
    }

    public QName getName() {
        return TransformationPolicyBuilder.TRANSFORMATION;
    }

    public boolean isOptional() {
        return false;
    }

    public boolean isIgnorable() {
        return false;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String prefix = writer.getPrefix("http://types.talend.com/policy/assertion/1.0");
        if (prefix == null) {
            prefix = NS_PREFIX;
            writer.setPrefix(prefix, "http://types.talend.com/policy/assertion/1.0");
        }
        writer.writeStartElement(prefix, "Transformation", "http://types.talend.com/policy/assertion/1.0");
        writer.writeNamespace(prefix, "http://types.talend.com/policy/assertion/1.0");
        writer.writeAttribute(null, PATH_ATTRIBUTE_NAME, String.valueOf(this.path));
        writer.writeAttribute(null, APPLIES_TO_ATTRIBUTE_NAME, String.valueOf(this.appliesTo));
        writer.writeAttribute(null, MESSAGE_TYPE_ATTRIBUTE_NAME, String.valueOf(this.messageType));
        writer.writeEndElement();
    }

    public PolicyComponent normalize() {
        return this;
    }

    public TransformationType getTransformationType() {
        return this.transformationType;
    }

    public String getPath() {
        return this.path;
    }

    public String getAppliesTo() {
        return this.appliesTo;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public static enum MessageType {
        request,
        response,
        all,
        none;

    }

    public static enum AppliesToType {
        consumer,
        provider,
        always,
        none;

    }
}

