/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.policy.transformation;

import java.util.Map;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.interceptor.transform.TransformInInterceptor;
import org.apache.cxf.message.Message;
import org.talend.esb.policy.transformation.AbstractTransformationPolicyInterceptor;
import org.talend.esb.policy.transformation.TransformationAssertion;
import org.talend.esb.policy.transformation.interceptor.xslt.HttpAwareXSLTInInterceptor;

public class TransformationPolicyInInterceptor
extends AbstractTransformationPolicyInterceptor {
    public TransformationPolicyInInterceptor() {
        super("post-stream");
        this.addBefore(StaxInInterceptor.class.getName());
    }

    @Override
    protected void proceedXSLT(Message message, TransformationAssertion tas) {
        String xsltPath = (String)message.getContextualProperty("org.talend.esb.transformation.xslt-path");
        if (xsltPath == null) {
            xsltPath = tas.getPath();
        }
        if (xsltPath != null) {
            TransformationAssertion.MessageType msgType = TransformationAssertion.MessageType.valueOf(tas.getMessageType());
            TransformationAssertion.AppliesToType appliesToType = TransformationAssertion.AppliesToType.valueOf(tas.getAppliesTo());
            HttpAwareXSLTInInterceptor xsltIn = new HttpAwareXSLTInInterceptor(xsltPath);
            xsltIn.setMsgType(msgType);
            xsltIn.setAppliesToType(appliesToType);
            xsltIn.handleMessage(message);
        }
    }

    @Override
    protected void proceedSimple(Message message, TransformationAssertion tas) {
        TransformationAssertion.AppliesToType appliesToType;
        TransformationAssertion.MessageType msgType = TransformationAssertion.MessageType.valueOf(tas.getMessageType());
        if (!this.shouldSchemaValidate(message, msgType, appliesToType = TransformationAssertion.AppliesToType.valueOf(tas.getAppliesTo()))) {
            return;
        }
        Object map = message.getContextualProperty("org.talend.esb.transformation.transform-map");
        if (!(map instanceof Map)) {
            return;
        }
        Map inTransformMap = (Map)map;
        TransformInInterceptor simpleIn = new TransformInInterceptor();
        simpleIn.setInTransformElements(inTransformMap);
        simpleIn.handleMessage(message);
    }
}

