/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.policy.transformation.feature;

import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.talend.esb.policy.transformation.TransformationAssertion;
import org.talend.esb.policy.transformation.TransformationType;
import org.talend.esb.policy.transformation.interceptor.xslt.HttpAwareXSLTInInterceptor;
import org.talend.esb.policy.transformation.interceptor.xslt.HttpAwareXSLTOutInterceptor;

@NoJSR250Annotations
public class TransformationFeature
extends AbstractFeature {
    private String path;
    private TransformationAssertion.MessageType messageType;
    private TransformationAssertion.AppliesToType appliesTo;
    private TransformationType transformationType = TransformationType.xslt;

    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        if (this.transformationType == TransformationType.xslt) {
            this.initializeXslt(provider);
        }
    }

    private void initializeXslt(InterceptorProvider provider) {
        if (this.path != null) {
            HttpAwareXSLTInInterceptor in = new HttpAwareXSLTInInterceptor(this.path);
            in.setAppliesToType(this.appliesTo);
            in.setMsgType(this.messageType);
            provider.getInInterceptors().add(in);
            HttpAwareXSLTOutInterceptor out = new HttpAwareXSLTOutInterceptor(this.path);
            out.setAppliesToType(this.appliesTo);
            out.setMsgType(this.messageType);
            provider.getOutInterceptors().add(out);
            provider.getOutFaultInterceptors().add(out);
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setType(String type) {
        this.transformationType = TransformationType.valueOf(type);
    }

    public void setAppliesTo(String appliesTo) {
        this.appliesTo = TransformationAssertion.AppliesToType.valueOf(appliesTo);
    }

    public void setMessage(String messageType) {
        this.messageType = TransformationAssertion.MessageType.valueOf(messageType);
    }
}

