/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.policy.transformation.interceptor.xslt;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.talend.esb.policy.transformation.TransformationAssertion;
import org.talend.esb.policy.transformation.TransformationPolicyBuilder;
import org.w3c.dom.Document;

public abstract class AbstractHttpAwareXSLTInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final TransformerFactory TRANSFORM_FACTORIY = TransformerFactory.newInstance();
    private String contextPropertyName;
    private final Templates xsltTemplate;
    private TransformationAssertion.MessageType msgType;
    private TransformationAssertion.AppliesToType appliesToType;

    public AbstractHttpAwareXSLTInterceptor(String phase, Class<?> before, Class<?> after, String xsltPath) {
        super(phase);
        InputStream xsltStream;
        if (before != null) {
            this.addBefore(before.getName());
        }
        if (after != null) {
            this.addAfter(after.getName());
        }
        HttpURLConnection urlConnection = null;
        if (xsltPath.startsWith("http://")) {
            try {
                URL url = new URL(xsltPath);
                urlConnection = (HttpURLConnection)url.openConnection();
                xsltStream = urlConnection.getInputStream();
            }
            catch (Exception e) {
                xsltStream = null;
            }
        } else {
            try {
                xsltStream = new FileInputStream(xsltPath);
            }
            catch (FileNotFoundException e) {
                xsltStream = null;
            }
            if (xsltStream == null) {
                xsltStream = ClassLoaderUtils.getResourceAsStream((String)xsltPath, ((Object)((Object)this)).getClass());
            }
        }
        try {
            if (xsltStream == null) {
                throw new IllegalArgumentException("Cannot load XSLT from path: " + xsltPath);
            }
            Document doc = StaxUtils.read((InputStream)xsltStream);
            this.xsltTemplate = TRANSFORM_FACTORIY.newTemplates(new DOMSource(doc));
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalArgumentException(String.format("Cannot create XSLT template from path: %s, error: ", xsltPath, e.getException()), e);
        }
        catch (XMLStreamException e) {
            throw new IllegalArgumentException(String.format("Cannot create XSLT template from path: %s, error: ", xsltPath, e.getNestedException()), e);
        }
        finally {
            if (xsltStream != null) {
                try {
                    xsltStream.close();
                }
                catch (Exception e) {}
            }
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public void handleMessage(Message message) {
        try {
            this.performTransformation(message);
            this.confirmPolicyProcessing(message);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    protected abstract void performTransformation(Message var1);

    private void confirmPolicyProcessing(Message message) {
        Collection ais;
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (aim != null && (ais = (Collection)aim.get((Object)TransformationPolicyBuilder.TRANSFORMATION)) != null) {
            for (AssertionInfo ai : ais) {
                if (!(ai.getAssertion() instanceof TransformationAssertion)) continue;
                ai.setAsserted(true);
            }
        }
    }

    protected boolean shouldSchemaValidate(Message message) {
        if (MessageUtils.isRequestor((Message)message)) {
            if (MessageUtils.isOutbound((Message)message)) {
                return !(this.appliesToType != TransformationAssertion.AppliesToType.consumer && this.appliesToType != TransformationAssertion.AppliesToType.always || this.msgType != TransformationAssertion.MessageType.request && this.msgType != TransformationAssertion.MessageType.all);
            }
            return !(this.appliesToType != TransformationAssertion.AppliesToType.consumer && this.appliesToType != TransformationAssertion.AppliesToType.always || this.msgType != TransformationAssertion.MessageType.response && this.msgType != TransformationAssertion.MessageType.all);
        }
        if (MessageUtils.isOutbound((Message)message)) {
            return !(this.appliesToType != TransformationAssertion.AppliesToType.provider && this.appliesToType != TransformationAssertion.AppliesToType.always || this.msgType != TransformationAssertion.MessageType.response && this.msgType != TransformationAssertion.MessageType.all);
        }
        return !(this.appliesToType != TransformationAssertion.AppliesToType.provider && this.appliesToType != TransformationAssertion.AppliesToType.always || this.msgType != TransformationAssertion.MessageType.request && this.msgType != TransformationAssertion.MessageType.all);
    }

    public void setContextPropertyName(String propertyName) {
        this.contextPropertyName = propertyName;
    }

    protected boolean checkContextProperty(Message message) {
        return this.contextPropertyName != null && !MessageUtils.getContextualBoolean((Message)message, (String)this.contextPropertyName, (boolean)false);
    }

    protected Templates getXSLTTemplate() {
        return this.xsltTemplate;
    }

    public void setMsgType(TransformationAssertion.MessageType msgType) {
        this.msgType = msgType;
    }

    public void setAppliesToType(TransformationAssertion.AppliesToType appliesToType) {
        this.appliesToType = appliesToType;
    }
}

