/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.policy.transformation.interceptor.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.feature.transform.XSLTOutInterceptor;
import org.apache.cxf.feature.transform.XSLTUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.io.CachedWriter;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.DelegatingXMLStreamWriter;
import org.apache.cxf.staxutils.StaxUtils;
import org.talend.esb.policy.transformation.interceptor.xslt.AbstractHttpAwareXSLTInterceptor;

public class HttpAwareXSLTOutInterceptor
extends AbstractHttpAwareXSLTInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(XSLTOutInterceptor.class);

    public HttpAwareXSLTOutInterceptor(String xsltPath) {
        super("pre-stream", StaxOutInterceptor.class, null, xsltPath);
    }

    public HttpAwareXSLTOutInterceptor(String phase, Class<?> before, Class<?> after, String xsltPath) {
        super(phase, before, after, xsltPath);
    }

    @Override
    public void performTransformation(Message message) {
        if (!this.shouldSchemaValidate(message)) {
            return;
        }
        if (this.checkContextProperty(message)) {
            return;
        }
        XMLStreamWriter xWriter = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
        if (xWriter != null) {
            this.transformXWriter(message, xWriter);
        } else {
            OutputStream out = (OutputStream)message.getContent(OutputStream.class);
            if (out != null) {
                this.transformOS(message, out);
            } else {
                Writer writer = (Writer)message.getContent(Writer.class);
                if (writer != null) {
                    this.transformWriter(message, writer);
                }
            }
        }
    }

    protected void transformXWriter(Message message, XMLStreamWriter xWriter) {
        CachedWriter writer = new CachedWriter();
        XMLStreamWriter delegate = StaxUtils.createXMLStreamWriter((Writer)writer);
        XSLTStreamWriter wrapper = new XSLTStreamWriter(this.getXSLTTemplate(), writer, delegate, xWriter);
        message.setContent(XMLStreamWriter.class, (Object)wrapper);
        message.put((Object)"disable.outputstream.optimization", (Object)Boolean.TRUE);
    }

    protected void transformOS(Message message, OutputStream out) {
        CachedOutputStream wrapper = new CachedOutputStream();
        XSLTCachedOutputStreamCallback callback = new XSLTCachedOutputStreamCallback(this.getXSLTTemplate(), out);
        wrapper.registerCallback((CachedOutputStreamCallback)callback);
        message.setContent(OutputStream.class, (Object)wrapper);
    }

    protected void transformWriter(Message message, Writer writer) {
        XSLTCachedWriter wrapper = new XSLTCachedWriter(this.getXSLTTemplate(), writer);
        message.setContent(Writer.class, (Object)wrapper);
    }

    public static class XSLTCachedWriter
    extends CachedWriter {
        private final Templates xsltTemplate;
        private final Writer origWriter;

        public XSLTCachedWriter(Templates xsltTemplate, Writer origWriter) {
            this.xsltTemplate = xsltTemplate;
            this.origWriter = origWriter;
        }

        protected void doClose() {
            Reader transformedReader = null;
            try {
                transformedReader = XSLTUtils.transform((Templates)this.xsltTemplate, (Reader)this.getReader());
                IOUtils.copyAndCloseInput((Reader)transformedReader, (Writer)this.origWriter, (int)4096);
            }
            catch (IOException e) {
                throw new Fault("READER_COPY", LOG, (Throwable)e, new Object[]{e.getMessage()});
            }
            finally {
                try {
                    this.origWriter.close();
                }
                catch (IOException e) {
                    LOG.warning("Cannot close stream after transformation: " + e.getMessage());
                }
            }
        }
    }

    public static class XSLTCachedOutputStreamCallback
    implements CachedOutputStreamCallback {
        private final Templates xsltTemplate;
        private final OutputStream origStream;

        public XSLTCachedOutputStreamCallback(Templates xsltTemplate, OutputStream origStream) {
            this.xsltTemplate = xsltTemplate;
            this.origStream = origStream;
        }

        public void onFlush(CachedOutputStream wrapper) {
        }

        public void onClose(CachedOutputStream wrapper) {
            InputStream transformedStream = null;
            try {
                transformedStream = XSLTUtils.transform((Templates)this.xsltTemplate, (InputStream)wrapper.getInputStream());
                IOUtils.copyAndCloseInput((InputStream)transformedStream, (OutputStream)this.origStream);
            }
            catch (IOException e) {
                throw new Fault("STREAM_COPY", LOG, (Throwable)e, new Object[]{e.getMessage()});
            }
            finally {
                try {
                    this.origStream.close();
                }
                catch (IOException e) {
                    LOG.warning("Cannot close stream after transformation: " + e.getMessage());
                }
            }
        }
    }

    public static class XSLTStreamWriter
    extends DelegatingXMLStreamWriter {
        private final Templates xsltTemplate;
        private final CachedWriter cachedWriter;
        private final XMLStreamWriter origXWriter;

        public XSLTStreamWriter(Templates xsltTemplate, CachedWriter cachedWriter, XMLStreamWriter delegateXWriter, XMLStreamWriter origXWriter) {
            super(delegateXWriter);
            this.xsltTemplate = xsltTemplate;
            this.cachedWriter = cachedWriter;
            this.origXWriter = origXWriter;
        }

        public void close() {
            Reader transformedReader = null;
            try {
                super.flush();
                transformedReader = XSLTUtils.transform((Templates)this.xsltTemplate, (Reader)this.cachedWriter.getReader());
                StaxUtils.copy((Source)new StreamSource(transformedReader), (XMLStreamWriter)this.origXWriter);
            }
            catch (XMLStreamException e) {
                throw new Fault("STAX_COPY", LOG, (Throwable)e, new Object[]{e.getMessage()});
            }
            catch (IOException e) {
                throw new Fault("GET_CACHED_INPUT_STREAM", LOG, (Throwable)e, new Object[]{e.getMessage()});
            }
            finally {
                try {
                    if (transformedReader != null) {
                        transformedReader.close();
                    }
                    this.cachedWriter.close();
                    StaxUtils.close((XMLStreamWriter)this.origXWriter);
                    super.close();
                }
                catch (Exception e) {
                    LOG.warning("Cannot close stream after transformation: " + e.getMessage());
                }
            }
        }
    }
}

