/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.policy.transformation;

import java.util.Collection;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.talend.esb.policy.transformation.TransformationAssertion;
import org.talend.esb.policy.transformation.TransformationPolicyBuilder;
import org.talend.esb.policy.transformation.TransformationType;

public abstract class AbstractTransformationPolicyInterceptor
extends AbstractPhaseInterceptor<Message> {
    protected static final String XSLT_PATH = "org.talend.esb.transformation.xslt-path";
    protected static final String TRANSFORM_MAP = "org.talend.esb.transformation.transform-map";
    private TransformationAssertion featureAssertion;

    public AbstractTransformationPolicyInterceptor(String phase) {
        super(phase);
    }

    public AbstractTransformationPolicyInterceptor(String phase, TransformationAssertion assertion) {
        super(phase);
        if (assertion == null) {
            throw new IllegalArgumentException("Provided assertion is null");
        }
        this.featureAssertion = assertion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleMessage(Message message) {
        TransformationAssertion tas;
        AssertionInfo ai = null;
        try {
            ai = TransformationPolicyBuilder.getAssertion(message);
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
        if (ai == null || !(ai.getAssertion() instanceof TransformationAssertion)) {
            if (this.featureAssertion == null) {
                this.confirmPolicyProcessing(message);
                return;
            }
            tas = this.featureAssertion;
        } else {
            tas = (TransformationAssertion)ai.getAssertion();
        }
        TransformationType transformationType = tas.getTransformationType();
        if (transformationType == TransformationType.xslt) {
            this.proceedXSLT(message, tas);
        } else if (transformationType == TransformationType.simple) {
            this.proceedSimple(message, tas);
        }
        this.confirmPolicyProcessing(message);
    }

    protected abstract void proceedXSLT(Message var1, TransformationAssertion var2);

    protected abstract void proceedSimple(Message var1, TransformationAssertion var2);

    protected boolean shouldTransform(Message message, TransformationAssertion.MessageType msgType, TransformationAssertion.AppliesToType appliesToType) {
        if (MessageUtils.isRequestor((Message)message)) {
            if (MessageUtils.isOutbound((Message)message)) {
                return !(appliesToType != TransformationAssertion.AppliesToType.consumer && appliesToType != TransformationAssertion.AppliesToType.always || msgType != TransformationAssertion.MessageType.request && msgType != TransformationAssertion.MessageType.all);
            }
            return !(appliesToType != TransformationAssertion.AppliesToType.consumer && appliesToType != TransformationAssertion.AppliesToType.always || msgType != TransformationAssertion.MessageType.response && msgType != TransformationAssertion.MessageType.all);
        }
        if (MessageUtils.isOutbound((Message)message)) {
            return !(appliesToType != TransformationAssertion.AppliesToType.provider && appliesToType != TransformationAssertion.AppliesToType.always || msgType != TransformationAssertion.MessageType.response && msgType != TransformationAssertion.MessageType.all);
        }
        return !(appliesToType != TransformationAssertion.AppliesToType.provider && appliesToType != TransformationAssertion.AppliesToType.always || msgType != TransformationAssertion.MessageType.request && msgType != TransformationAssertion.MessageType.all);
    }

    protected void confirmPolicyProcessing(Message message) {
        Collection ais;
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (aim != null && (ais = (Collection)aim.get((Object)TransformationPolicyBuilder.TRANSFORMATION)) != null) {
            for (AssertionInfo ai : ais) {
                if (!(ai.getAssertion() instanceof TransformationAssertion)) continue;
                ai.setAsserted(true);
            }
        }
    }
}

