/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.policy.transformation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.binding.soap.interceptor.SoapOutInterceptor;
import org.apache.cxf.interceptor.transform.TransformOutInterceptor;
import org.apache.cxf.message.Message;
import org.talend.esb.policy.transformation.AbstractTransformationPolicyInterceptor;
import org.talend.esb.policy.transformation.TransformationAssertion;
import org.talend.esb.policy.transformation.util.xslt.OutputXSLTUtil;

public class TransformationPolicyOutInterceptor
extends AbstractTransformationPolicyInterceptor {
    private ConcurrentHashMap<String, OutputXSLTUtil> utilsCache = new ConcurrentHashMap();

    public TransformationPolicyOutInterceptor() {
        super("write");
        this.addAfter(SoapOutInterceptor.class.getName());
    }

    public TransformationPolicyOutInterceptor(TransformationAssertion assertion) {
        super("write", assertion);
        this.addAfter(SoapOutInterceptor.class.getName());
    }

    @Override
    protected void proceedXSLT(Message message, TransformationAssertion tas) {
        String xsltPath = (String)message.getContextualProperty("org.talend.esb.transformation.xslt-path");
        if (xsltPath == null) {
            xsltPath = tas.getPath();
        }
        if (xsltPath != null) {
            OutputXSLTUtil xsltOut;
            if (!this.shouldTransform(message, tas.getMessageType(), tas.getAppliesTo())) {
                return;
            }
            if (this.utilsCache.containsKey(xsltPath)) {
                xsltOut = this.utilsCache.get(xsltPath);
            } else {
                xsltOut = new OutputXSLTUtil(xsltPath);
                this.utilsCache.put(xsltPath, xsltOut);
            }
            xsltOut.handleMessage(message);
        }
    }

    @Override
    protected void proceedSimple(Message message, TransformationAssertion tas) {
        if (!this.shouldTransform(message, tas.getMessageType(), tas.getAppliesTo())) {
            return;
        }
        Object map = message.getContextualProperty("org.talend.esb.transformation.transform-map");
        if (!(map instanceof Map)) {
            return;
        }
        Map outTransformMap = (Map)map;
        TransformOutInterceptor simpleOut = new TransformOutInterceptor();
        simpleOut.setOutTransformElements(outTransformMap);
        simpleOut.handleMessage(message);
    }
}

