/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.policy.transformation.util.xslt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.talend.esb.policy.transformation.TransformationAssertion;
import org.talend.esb.policy.transformation.TransformationPolicyBuilder;
import org.w3c.dom.Document;

public abstract class AbstractXSLTUtil {
    private String contextPropertyName;
    private final Templates xsltTemplate;

    public AbstractXSLTUtil(String xsltPath) {
        InputStream xsltStream = null;
        String absoluteSchemaPath = null;
        try {
            CachedOutputStream cos = new CachedOutputStream();
            absoluteSchemaPath = this.loadResource(xsltPath, (OutputStream)cos);
            xsltStream = cos.getInputStream();
            if (xsltStream == null) {
                throw new IllegalArgumentException("Cannot load XSLT from path: " + xsltPath);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot load XSLT from path: " + xsltPath, ex);
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setURIResolver(new XSLTResourceResolver(absoluteSchemaPath, xsltPath));
        try {
            Document doc = StaxUtils.read((InputStream)xsltStream);
            this.xsltTemplate = factory.newTemplates(new DOMSource(doc));
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalArgumentException(String.format("Cannot create XSLT template from path: %s, error: ", xsltPath, e.getException()), e);
        }
        catch (XMLStreamException e) {
            throw new IllegalArgumentException(String.format("Cannot create XSLT template from path: %s, error: ", xsltPath, e.getNestedException()), e);
        }
        finally {
            if (xsltStream != null) {
                try {
                    xsltStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String loadResource(String path, OutputStream output) throws IOException {
        URL url;
        InputStream resource = null;
        String absolutePath = null;
        try {
            resource = new FileInputStream(path);
            if (resource != null) {
                absolutePath = path;
            }
        }
        catch (FileNotFoundException e) {
            resource = null;
        }
        if (resource == null && (resource = ClassLoaderUtils.getResourceAsStream((String)path, this.getClass())) != null && (url = ClassLoaderUtils.getResource((String)path, this.getClass())) != null) {
            absolutePath = url.getPath();
        }
        if (resource == null) {
            try {
                url = new URL(path);
                resource = url.openStream();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resource != null) {
            IOUtils.copyAndCloseInput((InputStream)resource, (OutputStream)output);
            return absolutePath;
        }
        return null;
    }

    public void handleMessage(Message message) {
        try {
            this.performTransformation(message);
            this.confirmPolicyProcessing(message);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    protected abstract void performTransformation(Message var1);

    private void confirmPolicyProcessing(Message message) {
        Collection ais;
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (aim != null && (ais = (Collection)aim.get((Object)TransformationPolicyBuilder.TRANSFORMATION)) != null) {
            for (AssertionInfo ai : ais) {
                if (!(ai.getAssertion() instanceof TransformationAssertion)) continue;
                ai.setAsserted(true);
            }
        }
    }

    public void setContextPropertyName(String propertyName) {
        this.contextPropertyName = propertyName;
    }

    protected boolean checkContextProperty(Message message) {
        return this.contextPropertyName != null && !MessageUtils.getContextualBoolean((Message)message, (String)this.contextPropertyName, (boolean)false);
    }

    protected Templates getXSLTTemplate() {
        return this.xsltTemplate;
    }

    protected boolean isRequestor(Message message) {
        return MessageUtils.isRequestor((Message)message);
    }

    protected boolean isGET(Message message) {
        String method = (String)message.get((Object)"org.apache.cxf.request.method");
        return "GET".equals(method) && message.getContent(XMLStreamReader.class) == null;
    }

    class XSLTResourceResolver
    implements URIResolver {
        String parentXSLTAbsolutePath = null;
        String parentXSLTProvidedPath = null;

        public XSLTResourceResolver(String parentXSLTAbsolutePath, String parentXSLTProvidedPath) {
            this.parentXSLTAbsolutePath = parentXSLTAbsolutePath;
            this.parentXSLTProvidedPath = parentXSLTProvidedPath;
        }

        @Override
        public Source resolve(String systemId, String baseURI) {
            File file;
            boolean isRemoteLocation = systemId != null && (systemId.startsWith("http://") || systemId.startsWith("https://"));
            String parentXSLTDir = "";
            if (this.parentXSLTAbsolutePath != null && !isRemoteLocation && (file = new File(this.parentXSLTAbsolutePath)).exists()) {
                parentXSLTDir = file.getParentFile().getAbsolutePath();
            }
            String resURL = null;
            if (systemId != null) {
                String XSLTLocation = "";
                if (baseURI != null) {
                    XSLTLocation = baseURI.substring(0, baseURI.lastIndexOf("/") + 1);
                }
                resURL = !isRemoteLocation ? XSLTLocation + systemId : systemId;
            }
            CachedOutputStream cache = new CachedOutputStream();
            InputStream resourceStream = null;
            String actualXSLTURL = null;
            try {
                actualXSLTURL = resURL;
                AbstractXSLTUtil.this.loadResource(actualXSLTURL, (OutputStream)cache);
                if (cache.size() == 0L && parentXSLTDir != null && !parentXSLTDir.isEmpty() && !isRemoteLocation) {
                    actualXSLTURL = parentXSLTDir + File.separator + resURL;
                    AbstractXSLTUtil.this.loadResource(actualXSLTURL, (OutputStream)cache);
                }
                resourceStream = cache.getInputStream();
            }
            catch (IOException ex) {
                return null;
            }
            if (cache.size() != 0L) {
                StreamSource source = new StreamSource(resourceStream);
                source.setSystemId(actualXSLTURL);
                return source;
            }
            StringBuilder message = new StringBuilder();
            message.append("Transformation: can not load internal XSLT with path {");
            if (systemId == null) {
                message.append(resURL);
            } else {
                message.append(systemId);
            }
            message.append("}");
            throw new RuntimeException(message.toString());
        }
    }
}

