/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.policy.transformation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.interceptor.transform.TransformInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.talend.esb.policy.transformation.AbstractTransformationPolicyInterceptor;
import org.talend.esb.policy.transformation.TransformationAssertion;
import org.talend.esb.policy.transformation.util.xslt.InputXSLTUtil;

public class TransformationPolicyInInterceptor
extends AbstractTransformationPolicyInterceptor {
    private ConcurrentHashMap<String, InputXSLTUtil> utilsCache = new ConcurrentHashMap();

    public TransformationPolicyInInterceptor() {
        super("pre-protocol");
        this.addAfter(PolicyBasedWSS4JInInterceptor.class.getName());
        this.addAfter(WSS4JInInterceptor.class.getName());
    }

    public TransformationPolicyInInterceptor(TransformationAssertion assertion) {
        super("pre-protocol", assertion);
        this.addAfter(PolicyBasedWSS4JInInterceptor.class.getName());
        this.addAfter(WSS4JInInterceptor.class.getName());
    }

    @Override
    protected void proceedXSLT(Message message, TransformationAssertion tas) {
        String xsltPath = (String)message.getContextualProperty("org.talend.esb.transformation.xslt-path");
        if (xsltPath == null) {
            xsltPath = tas.getPath();
        }
        if (xsltPath != null) {
            InputXSLTUtil xsltIn;
            if (!this.shouldTransform(message, tas.getMessageType(), tas.getAppliesTo())) {
                return;
            }
            if (this.utilsCache.containsKey(xsltPath)) {
                xsltIn = this.utilsCache.get(xsltPath);
            } else {
                xsltIn = new InputXSLTUtil(xsltPath);
                this.utilsCache.put(xsltPath, xsltIn);
            }
            xsltIn.handleMessage(message);
        }
    }

    @Override
    protected void proceedSimple(Message message, TransformationAssertion tas) {
        if (!this.shouldTransform(message, tas.getMessageType(), tas.getAppliesTo())) {
            return;
        }
        Object map = message.getContextualProperty("org.talend.esb.transformation.transform-map");
        if (!(map instanceof Map)) {
            return;
        }
        Map inTransformMap = (Map)map;
        TransformInInterceptor simpleIn = new TransformInInterceptor();
        simpleIn.setInTransformElements(inTransformMap);
        simpleIn.handleMessage(message);
    }
}

