/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.TaskScheduler;
import org.talend.esb.sam.agent.collector.QueueSender;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.event.MonitoringException;
import org.talend.esb.sam.common.service.MonitoringService;
import org.talend.esb.sam.common.spi.EventFilter;
import org.talend.esb.sam.common.spi.EventHandler;

public class EventCollectorImpl
implements BusLifeCycleListener,
InitializingBean {
    private static Logger logger = Logger.getLogger(EventCollectorImpl.class.getName());
    private Bus bus;
    private MonitoringService monitoringServiceClient;
    @Autowired(required=false)
    private List<EventFilter> filters = new ArrayList<EventFilter>();
    private List<EventHandler> handlers = new ArrayList<EventHandler>();
    private Queue<Event> queue = new ConcurrentLinkedQueue<Event>();
    private TaskExecutor executor;
    private TaskScheduler scheduler;
    private long defaultInterval = 1000L;
    private int eventsPerMessageCall = 10;
    private boolean stopSending = false;

    public int getEventsPerMessageCall() {
        if (this.eventsPerMessageCall <= 0) {
            logger.warning("Message package size is not set or is lower then 1. Set package size to 1.");
            return 1;
        }
        return this.eventsPerMessageCall;
    }

    public void setEventsPerMessageCall(int eventsPerMessageCall) {
        this.eventsPerMessageCall = eventsPerMessageCall;
    }

    private long getDefaultInterval() {
        return this.defaultInterval;
    }

    public void setDefaultInterval(long defaultInterval) {
        this.defaultInterval = defaultInterval;
    }

    public void setScheduler(TaskScheduler scheduler) {
        logger.info("Scheduler startet for sending events to monitoring service");
        this.scheduler = scheduler;
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                EventCollectorImpl.this.sendEventsFromQueue();
            }
        }, this.getDefaultInterval());
    }

    public void setExecutor(TaskExecutor executor) {
        this.executor = executor;
    }

    public void setQueue(Queue<Event> queue) {
        this.queue = queue;
    }

    public void setMonitoringServiceClient(MonitoringService monitoringServiceClient) {
        this.monitoringServiceClient = monitoringServiceClient;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public List<EventFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<EventFilter> filters) {
        this.filters = filters;
    }

    public List<EventHandler> getHandlers() {
        return this.handlers;
    }

    @Autowired(required=false)
    public void setHandlers(List<EventHandler> newHandlers) {
        this.handlers.clear();
        for (EventHandler eventHandler : newHandlers) {
            if (eventHandler instanceof QueueSender) continue;
            this.handlers.add(eventHandler);
        }
    }

    public void sendEventsFromQueue() {
        if (this.stopSending) {
            return;
        }
        logger.fine("Scheduler called for sending events");
        int packageSize = this.getEventsPerMessageCall();
        while (!this.queue.isEmpty()) {
            final ArrayList<Event> list = new ArrayList<Event>();
            int i = 0;
            while (i < packageSize && !this.queue.isEmpty()) {
                Event event = this.queue.remove();
                if (event == null || this.filter(event)) continue;
                list.add(event);
                ++i;
            }
            if (list.size() <= 0) continue;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        EventCollectorImpl.this.sendEvents(list);
                    }
                    catch (MonitoringException e) {
                        e.logException(Level.SEVERE);
                    }
                }
            });
        }
    }

    private boolean filter(Event event) {
        for (EventFilter filter : this.filters) {
            if (!filter.filter(event)) continue;
            return true;
        }
        return false;
    }

    private void sendEvents(List<Event> events) {
        for (EventHandler current : this.handlers) {
            for (Event event : events) {
                current.handleEvent(event);
            }
        }
        logger.info("Put events(" + events.size() + ") to Monitoring Server.");
        try {
            this.monitoringServiceClient.putEvents(events);
        }
        catch (Exception e) {
            if (e instanceof MonitoringException) {
                throw (MonitoringException)((Object)e);
            }
            throw new MonitoringException("002", "Unknown error while execute put events to Monitoring Server", (Throwable)e);
        }
    }

    public void stopSending() {
    }

    public void initComplete() {
    }

    public void preShutdown() {
        logger.info("Bus is stopping. Stopping sending events to monitoring service.");
        this.stopSending = true;
    }

    public void postShutdown() {
    }

    public void afterPropertiesSet() throws Exception {
        BusLifeCycleManager lm;
        if (this.bus != null && null != (lm = (BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class))) {
            lm.registerLifeCycleListener((BusLifeCycleListener)this);
        }
    }
}

