/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.eventproducer;

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.talend.esb.sam.agent.eventproducer.MessageToEventMapper;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.spi.EventHandler;

public class EventProducerInterceptor
extends AbstractPhaseInterceptor<Message> {
    MessageToEventMapper mapper;
    EventHandler eventSender;

    public EventProducerInterceptor(MessageToEventMapper mapper, EventHandler eventSender) {
        super("pre-invoke");
        if (mapper == null) {
            throw new RuntimeException("Mapper must be set on EventFeature");
        }
        if (eventSender == null) {
            throw new RuntimeException("EventSender must be set on EventFeature");
        }
        this.mapper = mapper;
        this.eventSender = eventSender;
    }

    public void handleMessage(Message message) throws Fault {
        Event event = this.mapper.mapToEvent(message);
        this.eventSender.handleEvent(event);
    }
}

