/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.flowidprocessor;

import java.util.logging.Logger;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.talend.esb.sam.agent.flowidprocessor.FlowIdProtocolHeaderCodec;
import org.talend.esb.sam.agent.flowidprocessor.FlowIdSoapCodec;
import org.talend.esb.sam.agent.message.FlowIdHelper;

public class FlowIdProducerIn<T extends Message>
extends AbstractPhaseInterceptor<T> {
    protected static Logger logger = Logger.getLogger(FlowIdProducerIn.class.getName());

    public FlowIdProducerIn() {
        super("pre-invoke");
    }

    public void handleMessage(T message) throws Fault {
        String flowId = FlowIdHelper.getFlowId(message);
        if (flowId == null) {
            flowId = FlowIdProtocolHeaderCodec.readFlowId(message);
        }
        if (flowId == null) {
            flowId = FlowIdSoapCodec.readFlowId(message);
        }
        FlowIdHelper.setFlowId(message, flowId);
        if (flowId != null) {
            logger.info("FlowId '" + flowId + "' found in FlowId");
        }
        if (flowId == null) {
            flowId = ContextUtils.generateUUID();
            logger.fine("No flowId found in incoming message. Generating flowId " + flowId);
            FlowIdHelper.setFlowId(message, flowId);
        }
    }
}

